/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.ClipboardProxyGTK4;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.GTK4GlibFuture;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static long GTKCLIPBOARD;
    static long GTKPRIMARYCLIPBOARD;
    private static long TARGET;

    static {
        if (GTK.GTK4) {
            GTKCLIPBOARD = GDK.gdk_display_get_clipboard(GDK.gdk_display_get_default());
            GTKPRIMARYCLIPBOARD = GDK.gdk_display_get_primary_clipboard(GDK.gdk_display_get_default());
            TARGET = 0L;
        } else {
            GTKCLIPBOARD = GTK3.gtk_clipboard_get(0L);
            byte[] buffer = Converter.wcsToMbcs("PRIMARY", true);
            long primary = GDK.gdk_atom_intern(buffer, false);
            GTKPRIMARYCLIPBOARD = GTK3.gtk_clipboard_get(primary);
            buffer = Converter.wcsToMbcs("TARGETS", true);
            TARGET = GDK.gdk_atom_intern(buffer, false);
        }
    }

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = Clipboard.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        if (GTK.GTK4) {
            ClipboardProxyGTK4 proxy = ClipboardProxyGTK4._getInstance(this.display);
            proxy.clear(this, clipboards, false);
        } else {
            ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
            proxy.clear(this, clipboards);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        if (GTK.GTK4) {
            CompletableFuture<Object> contentsAsync = this.gtk4_getContentsAsync(transfer, clipboards);
            try {
                return GTK4GlibFuture.get(this.display, contentsAsync, Duration.ofSeconds(5L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            catch (ExecutionException | TimeoutException e) {
                ClipboardProxyGTK4 proxy = ClipboardProxyGTK4._getInstance(this.display);
                proxy.clear(this, clipboards, true);
                return null;
            }
        }
        return this.gtk3_getContents(transfer, clipboards);
    }

    private Object gtk3_getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        long selection_data = 0L;
        int[] typeIds = transfer.getTypeIds();
        boolean textTransfer = transfer.getTypeNames()[0].equals("UTF8_STRING");
        Object result = null;
        int i = 0;
        while (i < typeIds.length) {
            if ((clipboards & 1) != 0) {
                selection_data = this.gtk3_clipboard_wait_for_contents(GTKCLIPBOARD, typeIds[i]);
            }
            if (selection_data == 0L && (clipboards & 2) != 0) {
                selection_data = this.gtk3_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, typeIds[i]);
            }
            if (selection_data != 0L) {
                TransferData tdata = new TransferData();
                tdata.type = GTK3.gtk_selection_data_get_data_type(selection_data);
                tdata.pValue = GTK3.gtk_selection_data_get_data(selection_data);
                tdata.length = GTK3.gtk_selection_data_get_length(selection_data);
                tdata.format = GTK3.gtk_selection_data_get_format(selection_data);
                result = transfer.nativeToJava(tdata);
                GTK3.gtk_selection_data_free(selection_data);
                selection_data = 0L;
                if (result != null || !textTransfer) break;
            }
            ++i;
        }
        return result;
    }

    public CompletableFuture<Object> getContentsAsync(Transfer transfer) {
        return this.getContentsAsync(transfer, 1);
    }

    public CompletableFuture<Object> getContentsAsync(Transfer transfer, int clipboards) {
        if (GTK.GTK4) {
            return this.gtk4_getContentsAsync(transfer, clipboards);
        }
        return CompletableFuture.completedFuture(this.gtk3_getContents(transfer, clipboards));
    }

    private CompletableFuture<Object> gtk4_getContentsAsync(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        ClipboardProxyGTK4 proxy = ClipboardProxyGTK4._getInstance(this.display);
        return proxy.getData(this, transfer, clipboards);
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        if (GTK.GTK4) {
            ClipboardProxyGTK4 proxy = ClipboardProxyGTK4._getInstance(this.display);
            if (!proxy.setData(this, data, dataTypes, clipboards)) {
                DND.error(2002);
            }
        } else {
            ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
            if (!proxy.setData(this, data, dataTypes, clipboards)) {
                DND.error(2002);
            }
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        int[] types;
        this.checkWidget();
        if (GTK.GTK4) {
            return this.gtk4_getAvailableTypes(clipboards);
        }
        TransferData[] result = null;
        if ((clipboards & 1) != 0) {
            types = this.gtk3_getAvailableTypes(GTKCLIPBOARD);
            result = new TransferData[types.length];
            int i = 0;
            while (i < types.length) {
                result[i] = new TransferData();
                result[i].type = types[i];
                ++i;
            }
        }
        if ((clipboards & 2) != 0) {
            types = this.gtk3_getAvailableTypes(GTKPRIMARYCLIPBOARD);
            int offset = 0;
            if (result != null) {
                TransferData[] newResult = new TransferData[result.length + types.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                offset = result.length;
                result = newResult;
            } else {
                result = new TransferData[types.length];
            }
            int i = 0;
            while (i < types.length) {
                result[offset + i] = new TransferData();
                result[offset + i].type = types[i];
                ++i;
            }
        }
        return result == null ? new TransferData[]{} : result;
    }

    public String[] getAvailableTypeNames() {
        byte[] buffer;
        long pName;
        this.checkWidget();
        if (GTK.GTK4) {
            return this.gtk4_getAvailableTypeNames();
        }
        int[] types1 = this.gtk3_getAvailableTypes(GTKCLIPBOARD);
        int[] types2 = this.gtk3_getAvailableTypes(GTKPRIMARYCLIPBOARD);
        String[] result = new String[types1.length + types2.length];
        int count = 0;
        int i = 0;
        while (i < types1.length) {
            pName = GDK.gdk_atom_name(types1[i]);
            if (pName != 0L) {
                buffer = new byte[C.strlen(pName)];
                C.memmove(buffer, pName, (long)buffer.length);
                OS.g_free(pName);
                result[count++] = "GTKCLIPBOARD " + new String(Converter.mbcsToWcs(buffer));
            }
            ++i;
        }
        i = 0;
        while (i < types2.length) {
            pName = GDK.gdk_atom_name(types2[i]);
            if (pName != 0L) {
                buffer = new byte[C.strlen(pName)];
                C.memmove(buffer, pName, (long)buffer.length);
                OS.g_free(pName);
                result[count++] = "GTKPRIMARYCLIPBOARD " + new String(Converter.mbcsToWcs(buffer));
            }
            ++i;
        }
        if (count < result.length) {
            String[] temp = new String[count];
            System.arraycopy(result, 0, temp, 0, count);
            result = temp;
        }
        return result;
    }

    private TransferData[] gtk4_getAvailableTypes(int clipboards) {
        return (TransferData[])Arrays.stream(this.gtk4_getAvailableTypeNames(clipboards)).map(Transfer::registerType).map(type -> {
            TransferData transferData = new TransferData();
            transferData.type = type.intValue();
            return transferData;
        }).toArray(TransferData[]::new);
    }

    private String[] gtk4_getAvailableTypeNames() {
        LinkedHashSet all = new LinkedHashSet();
        Arrays.stream(this.gtk4_getAvailableTypeNames(1)).map(n -> "GTKCLIPBOARD " + n).forEachOrdered(all::add);
        Arrays.stream(this.gtk4_getAvailableTypeNames(2)).map(n -> "GTKPRIMARYCLIPBOARD " + n).forEachOrdered(all::add);
        return (String[])all.toArray(String[]::new);
    }

    private String[] gtk4_getAvailableTypeNames(int clipboards) {
        long[] n_mime_types;
        long mime_types;
        long[] ptr;
        int i;
        long[] n_gtypes;
        long gtkClipboard = (clipboards & 1) != 0 ? GTKCLIPBOARD : GTKPRIMARYCLIPBOARD;
        ArrayList<String> names = new ArrayList<String>();
        long formats = GTK4.gdk_clipboard_get_formats(gtkClipboard);
        long gtypes = GTK4.gdk_content_formats_get_gtypes(formats, n_gtypes = new long[1]);
        if (gtypes != 0L) {
            int gtypes_length = (int)n_gtypes[0];
            i = 0;
            while (i < gtypes_length) {
                long g_type_name;
                ptr = new long[1];
                C.memmove(ptr, gtypes + (long)(i * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
                long gtype = ptr[0];
                if (gtype == 0L) break;
                if (gtype != OS.G_TYPE_INVALID() && (g_type_name = OS.g_type_name(gtype)) != 0L) {
                    String gtypeName = Converter.cCharPtrToJavaString(g_type_name, false);
                    names.add(gtypeName);
                }
                ++i;
            }
        }
        if ((mime_types = GTK4.gdk_content_formats_get_mime_types(formats, n_mime_types = new long[1])) != 0L) {
            int mime_types_length = (int)n_mime_types[0];
            i = 0;
            while (i < mime_types_length) {
                ptr = new long[1];
                C.memmove(ptr, mime_types + (long)(i * C.PTR_SIZEOF), (long)C.PTR_SIZEOF);
                long mime_type = ptr[0];
                if (mime_type == 0L) break;
                String typeName = Converter.cCharPtrToJavaString(mime_type, false);
                if (!typeName.isBlank()) {
                    names.add(typeName);
                }
                ++i;
            }
        }
        return (String[])names.toArray(String[]::new);
    }

    private int[] gtk3_getAvailableTypes(long clipboard) {
        int[] types = new int[]{};
        long selection_data = this.gtk3_clipboard_wait_for_contents(clipboard, TARGET);
        if (selection_data != 0L) {
            try {
                int length = GTK3.gtk_selection_data_get_length(selection_data);
                int format = GTK3.gtk_selection_data_get_format(selection_data);
                long data = GTK3.gtk_selection_data_get_data(selection_data);
                if (length != 0) {
                    types = new int[length * 8 / format];
                    C.memmove(types, data, (long)length);
                }
            }
            finally {
                GTK3.gtk_selection_data_free(selection_data);
            }
        }
        return types;
    }

    private long gtk3_clipboard_wait_for_contents(long clipboard, long target) {
        long startTime = System.currentTimeMillis();
        String key = "org.eclipse.swt.internal.gtk.dispatchEvent";
        Display display = this.display;
        display.setData(key, new int[]{16, 17, 18, 19});
        long selection_data = GTK3.gtk_clipboard_wait_for_contents(clipboard, target);
        display.setData(key, null);
        long duration = System.currentTimeMillis() - startTime;
        if (selection_data == 0L && duration > 5000L) {
            ClipboardProxy._getInstance(display).setData(this, new String[]{" "}, new Transfer[]{TextTransfer.getInstance()}, clipboard == GTKCLIPBOARD ? 1 : 2);
        }
        return selection_data;
    }
}

