/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.util.Collection;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.server.core.types.IServerType;
import org.eclipse.php.server.core.types.ServerTypesManager;
import org.eclipse.php.server.ui.types.IServerTypeDescriptor;
import org.eclipse.php.server.ui.types.ServerTypesDescriptorRegistry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class ServerTypeCompositeFragment
extends CompositeFragment {
    private IServerType currentType;

    public ServerTypeCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.setTitle(PHPServerUIMessages.getString("ServerTypeCompositeFragment.Title"));
        this.setDescription(PHPServerUIMessages.getString("ServerTypeCompositeFragment.Description"));
        this.controlHandler.setTitle(PHPServerUIMessages.getString("ServerTypeCompositeFragment.Title"));
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.setDisplayName(PHPServerUIMessages.getString("ServerCompositeFragment.server"));
    }

    public boolean isComplete() {
        return this.getType() != null;
    }

    public boolean performOk() {
        Server server = this.getServer();
        server.setAttribute("serverType", this.currentType.getId());
        return true;
    }

    public void setData(Object server) throws IllegalArgumentException {
        if (server != null && !(server instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.validate();
    }

    public void validate() {
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    public IServerType getType() {
        return this.currentType;
    }

    protected void createContents(Composite parent) {
        Collection types = ServerTypesManager.getInstance().getAll();
        TableViewer viewer = new TableViewer(parent);
        Table table = viewer.getTable();
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 40;
            }
        });
        table.setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object input) {
                if (input instanceof Collection) {
                    Collection entries = (Collection)input;
                    return entries.toArray(new IServerType[entries.size()]);
                }
                return new IServerType[0];
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new TypesLabelProvider());
        viewer.setInput((Object)types);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (!structuredSelection.isEmpty()) {
                    ServerTypeCompositeFragment.this.currentType = (IServerType)structuredSelection.toArray()[0];
                    ServerTypeCompositeFragment.this.controlHandler.update();
                }
            }
        });
        this.validate();
        Dialog.applyDialogFont((Control)parent);
    }

    private class TypesLabelProvider
    extends StyledCellLabelProvider {
        private TypesLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IServerType) {
                String name = ((IServerType)element).getName();
                String description = ((IServerType)element).getDescription();
                cell.setText(name + "\n" + description);
                IServerTypeDescriptor serverTypeDescriptor = ServerTypesDescriptorRegistry.getDescriptor((IServerType)element);
                cell.setImage(serverTypeDescriptor.getImage(IServerTypeDescriptor.ImageType.ICON_32));
                StyleRange greyDesc = new StyleRange(name.length() + 1, description.length(), Display.getDefault().getSystemColor(16), null);
                StyleRange[] range = new StyleRange[]{greyDesc};
                cell.setStyleRanges(range);
            }
            super.update(cell);
        }
    }
}

