/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.OperationOverrideMap;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;

class ModuleInstanceImpl
extends DynamicEObjectImpl
implements ModuleInstance,
ModuleInstance.Internal {
    private Map<Module, ModuleInstance> fInstanceMap;
    private Map<Module, OperationOverrideMap> fOverrideMap;
    private List<Object> fAdapters = Collections.emptyList();
    private boolean fIsInitialized = false;

    ModuleInstanceImpl(Module moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException("Null module class");
        }
        this.eSetClass(moduleType);
    }

    @Override
    public List<ModuleInstance> getImportedModules() {
        Module thisModule = this.getModule();
        EList<ModuleImport> moduleImports = thisModule.getModuleImport();
        ArrayList<ModuleInstance> result = null;
        for (ModuleImport nextImport : moduleImports) {
            Module importedModule = nextImport.getImportedModule();
            if (nextImport.getKind() != ImportKind.EXTENSION && !(importedModule instanceof Library)) continue;
            if (result == null) {
                result = new ArrayList<ModuleInstance>(moduleImports.size());
            }
            result.add(this.getThisInstanceOf(importedModule));
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    @Override
    public ModuleInstance getThisInstanceOf(Module module) {
        if (module == this.eClass()) {
            return this;
        }
        return this.fInstanceMap != null ? this.fInstanceMap.get(module) : null;
    }

    @Override
    public Module getModule() {
        return (Module)this.eClass();
    }

    void setInstanceMap(Map<Module, ModuleInstance> instanceMap) {
        if (instanceMap == null) {
            throw new IllegalArgumentException();
        }
        this.fInstanceMap = instanceMap;
    }

    void setOverrideMap(Map<Module, OperationOverrideMap> overrideMap) {
        if (overrideMap == null) {
            throw new IllegalArgumentException();
        }
        this.fOverrideMap = overrideMap;
    }

    @Override
    public ImperativeOperation getOverridingOperation(ImperativeOperation overridden) {
        Module callerModule;
        OperationOverrideMap perModuleMap;
        if (this.fOverrideMap != null && (perModuleMap = this.fOverrideMap.get(callerModule = this.getModule())) != null) {
            return perModuleMap.getOverridingOperation(overridden);
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ModuleInstance.Internal.class || adapterType == ModuleInstance.class) {
            return adapterType.cast(this);
        }
        for (Object nextAdapter : this.fAdapters) {
            Class<?> nextAdapterType = nextAdapter.getClass();
            if (adapterType != nextAdapterType && !adapterType.isAssignableFrom(nextAdapterType)) continue;
            return adapterType.cast(nextAdapter);
        }
        return null;
    }

    @Override
    public void addAdapter(Object adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException();
        }
        if (this.fAdapters.isEmpty()) {
            this.fAdapters = new LinkedList<Object>();
        }
        this.fAdapters.add(adapter);
    }

    @Override
    public boolean isInitialized() {
        return this.fIsInitialized;
    }

    @Override
    public void setInitialized() {
        if (this.fIsInitialized) {
            throw new IllegalStateException("module instance already initialized");
        }
        this.fIsInitialized = true;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return String.valueOf(this.eClass().getName()) + " @" + Integer.toHexString(System.identityHashCode(this));
    }
}

