/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerPortDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class RunImagePortsTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunPortsTab.name";
    private static final int INDENT = 30;
    private static final int COLUMNS = 3;
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunSelectionModel model;

    public RunImagePortsTab(ImageRunSelectionModel model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
        } else {
            this.setErrorMessage(null);
            this.createPortSettingsSection(container);
        }
        this.setControl((Control)container);
    }

    private void createPortSettingsSection(Composite container) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)new Label(container, 0));
        Button publishAllPortsButton = new Button(container, 32);
        publishAllPortsButton.setText(WizardMessages.getString("ImageRunSelectionPage.publishAllPorts"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)publishAllPortsButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)publishAllPortsButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"publishAllPorts").observe((Object)this.model));
        Label portSettingsLabel = new Label(container, 0);
        portSettingsLabel.setText(WizardMessages.getString("ImageRunSelectionPage.portSettings"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).indent(30, 0).applyTo((Control)portSettingsLabel);
        CheckboxTableViewer exposedPortsTableViewer = this.createPortSettingsTable(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).indent(30, 0).hint(200, 70).applyTo((Control)exposedPortsTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunSelectionPage.add"));
        addButton.addSelectionListener(this.onAddPort(exposedPortsTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunSelectionPage.editButton"));
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditPort(exposedPortsTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunSelectionPage.remove"));
        removeButton.addSelectionListener(this.onRemovePorts((TableViewer)exposedPortsTableViewer));
        BeanProperties.value(ImageRunSelectionModel.class, (String)"publishAllPorts").observe((Object)this.model).addValueChangeListener(this.onPublishAllPortsChange(new Control[]{exposedPortsTableViewer.getTable(), addButton, removeButton}));
        ViewerSupport.bind((StructuredViewer)exposedPortsTableViewer, this.model.getExposedPorts(), (IValueProperty[])BeanProperties.values(ImageRunSelectionModel.ExposedPortModel.class, (String[])new String[]{"containerPort", "portType", "hostAddress", "hostPort"}));
        this.dbc.bindSet((IObservableSet)ViewerProperties.checkedElements(ImageRunSelectionModel.ExposedPortModel.class).observe((Viewer)exposedPortsTableViewer), BeanProperties.set((String)"selectedPorts").observe((Object)this.model));
        exposedPortsTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
        exposedPortsTableViewer.addCheckStateListener(this.onCheckStateChanged());
        this.togglePortMappingControls(new Control[]{exposedPortsTableViewer.getTable(), addButton, removeButton});
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        for (Control control : controls) {
            control.setEnabled(enabled);
        }
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                RunImagePortsTab.setControlsEnabled((Control[])targetButtons, false);
            } else {
                RunImagePortsTab.setControlsEnabled((Control[])targetButtons, true);
            }
        };
    }

    private ICheckStateListener onCheckStateChanged() {
        return e -> {
            ImageRunSelectionModel.ExposedPortModel element = (ImageRunSelectionModel.ExposedPortModel)e.getElement();
            if (e.getChecked()) {
                this.model.getSelectedPorts().add(element);
                element.setSelected(true);
            } else {
                this.model.getSelectedPorts().remove(element);
                element.setSelected(false);
            }
            this.updateLaunchConfigurationDialog();
        };
    }

    private CheckboxTableViewer createPortSettingsTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.containerPortColumn"), 100);
        this.createTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.typeColumn"), 50);
        this.createTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.hostAddressColumn"), 100);
        this.createTableViewerColumn((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.hostPortColumn"), 100);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        return tableViewer;
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private IValueChangeListener onPublishAllPortsChange(Control ... controls) {
        return event -> this.togglePortMappingControls(controls);
    }

    private SelectionListener onAddPort(CheckboxTableViewer exposedPortsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerPortDialog dialog = new ContainerPortDialog(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                ImageRunSelectionModel.ExposedPortModel port = dialog.getPort();
                this.model.addAvailablePort(port);
                this.model.getSelectedPorts().add(port);
                port.setSelected(true);
                exposedPortsTableViewer.setChecked((Object)port, true);
                this.updateLaunchConfigurationDialog();
            }
        });
    }

    private SelectionListener onEditPort(CheckboxTableViewer exposedPortsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = exposedPortsTableViewer.getStructuredSelection();
            ImageRunSelectionModel.ExposedPortModel selectedContainerPort = (ImageRunSelectionModel.ExposedPortModel)selection.getFirstElement();
            ContainerPortDialog dialog = new ContainerPortDialog(this.getShell(), selectedContainerPort);
            dialog.create();
            if (dialog.open() == 0) {
                ImageRunSelectionModel.ExposedPortModel configuredPort = dialog.getPort();
                selectedContainerPort.setContainerPort(configuredPort.getContainerPort());
                selectedContainerPort.setHostAddress(configuredPort.getHostAddress());
                selectedContainerPort.setHostPort(configuredPort.getHostPort());
            }
            this.updateLaunchConfigurationDialog();
        });
    }

    private SelectionListener onRemovePorts(TableViewer portsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = portsTableViewer.getStructuredSelection();
            for (ImageRunSelectionModel.ExposedPortModel port : selection) {
                this.model.removeAvailablePort(port);
                this.model.getSelectedPorts().remove(port);
            }
            this.updateLaunchConfigurationDialog();
        });
    }

    private void togglePortMappingControls(Control ... controls) {
        for (Control control : controls) {
            if (this.model.isPublishAllPorts()) {
                control.setEnabled(false);
            } else {
                control.setEnabled(true);
            }
            this.updateLaunchConfigurationDialog();
        }
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.container_port.png");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.model == null) {
            return;
        }
        try {
            ImageRunSelectionModel.ExposedPortModel exposedPort;
            this.model.removeExposedPorts();
            boolean publishAllPorts = configuration.getAttribute("publishAllPorts", true);
            this.model.setPublishAllPorts(publishAllPorts);
            List publishedPorts = configuration.getAttribute("publishedPorts", new ArrayList());
            List unusedPorts = configuration.getAttribute("unusedPorts", new ArrayList());
            HashSet<ImageRunSelectionModel.ExposedPortModel> selectedPorts = new HashSet<ImageRunSelectionModel.ExposedPortModel>();
            for (String port : publishedPorts) {
                exposedPort = ImageRunSelectionModel.ExposedPortModel.createPortModel(port);
                this.model.addExposedPort(exposedPort);
                if (!exposedPort.getSelected()) continue;
                selectedPorts.add(exposedPort);
            }
            for (String port : unusedPorts) {
                exposedPort = ImageRunSelectionModel.ExposedPortModel.createPortModel(port);
                exposedPort.setSelected(false);
                this.model.addExposedPort(exposedPort);
            }
            this.model.setSelectedPorts(selectedPorts);
            this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
        }
        catch (CoreException e) {
            Activator.logErrorMessage(LaunchMessages.getString("RunDockerImageLaunchConfiguration.load.failure"), e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.model == null) {
            return;
        }
        configuration.setAttribute("publishAllPorts", this.model.isPublishAllPorts());
        ArrayList<String> portsList = new ArrayList<String>();
        for (ImageRunSelectionModel.ExposedPortModel m : this.model.getExposedPorts()) {
            portsList.add(m.toString());
        }
        configuration.setAttribute("publishedPorts", portsList);
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImagePortsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

