/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.common;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.swt.graphics.Image;

public class MetadataTagImageManager {
    private static final String TRAIT_ICON_SMALL = "small-icon";
    private static final String TRAIT_ICON_LARGE = "large-icon";

    public Image getSmallIconImage(IFile file, TagIdentifier tagId) {
        return this.getSmallIconImage(file, tagId.getUri(), tagId.getTagName());
    }

    public Image getSmallIconImage(IFile file, String nsUri, String tagName) {
        Image image = null;
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = this.getModel(query, nsUri);
        if (model != null) {
            ImageDescriptor imgDesc = this.getIconImageDescriptor(query, model, tagName, true);
            image = this.getOrCreateImage(imgDesc);
        }
        return image;
    }

    private Image getOrCreateImage(ImageDescriptor imgDesc) {
        Image image = null;
        if (imgDesc != null) {
            image = JSFUiPlugin.getDefault().getImageRegistry().get(imgDesc.toString());
            if (image == null) {
                image = imgDesc.createImage();
                JSFUiPlugin.getDefault().getImageRegistry().put(imgDesc.toString(), image);
            } else if (image.isDisposed()) {
                JSFUiPlugin.getDefault().getImageRegistry().remove(imgDesc.toString());
                image = imgDesc.createImage();
                JSFUiPlugin.getDefault().getImageRegistry().put(imgDesc.toString(), image);
            }
        }
        return image;
    }

    private Model getModel(ITaglibDomainMetaDataQuery query, String nsUri) {
        Model model = query.findTagLibraryModel(nsUri);
        return model;
    }

    private ImageDescriptor getIconImageDescriptor(ITaglibDomainMetaDataQuery query, Model model, String tagName, boolean small) {
        ImageDescriptor icon = null;
        Trait trait = query.findTrait((Entity)model, "paletteInfos");
        if (trait != null) {
            PaletteInfos tags = (PaletteInfos)trait.getValue();
            for (PaletteInfo tag : tags.getInfos()) {
                if (!tag.getId().equalsIgnoreCase(tagName)) continue;
                IMetaDataSourceModelProvider sourceProvider = ((Trait)tag.eContainer().eContainer()).getSourceModelProvider();
                icon = small ? this.getImageDescriptorFromString(sourceProvider, tag.getSmallIcon()) : this.getImageDescriptorFromString(sourceProvider, tag.getLargeIcon());
                break;
            }
        } else {
            for (Entity tagAsEntity : model.getChildEntities()) {
                if (!tagAsEntity.getId().equalsIgnoreCase(tagName)) continue;
                icon = small ? this.getImageDescriptorFromTagTraitValueAsString(query, tagAsEntity, TRAIT_ICON_SMALL, ImageDescriptor.getMissingImageDescriptor()) : this.getImageDescriptorFromTagTraitValueAsString(query, tagAsEntity, TRAIT_ICON_LARGE, ImageDescriptor.getMissingImageDescriptor());
                break;
            }
        }
        return icon;
    }

    private ImageDescriptor getImageDescriptorFromString(IMetaDataSourceModelProvider sourceModelProvider, String imgDesc) {
        ImageDescriptor image = null;
        IImageDescriptorProvider imageProvider = (IImageDescriptorProvider)sourceModelProvider.getAdapter(IImageDescriptorProvider.class);
        if (imageProvider != null) {
            image = imageProvider.getImageDescriptor(imgDesc);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptorFromTagTraitValueAsString(ITaglibDomainMetaDataQuery query, Entity entity, String key, ImageDescriptor defaultValue) {
        Trait t = query.findTrait(entity, key);
        if (t != null) {
            String imgDesc = TraitValueHelper.getValueAsString((Trait)t);
            return this.getImageDescriptorFromString(t.getSourceModelProvider(), imgDesc);
        }
        return defaultValue;
    }
}

