/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcherExtensions;

public class ProposalCreator {
    private static final String PROPOSALS_PREFIX = "proposals_";
    private Resource resource;

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    protected void retrieveResource(EObject eObject) {
        this.resource = eObject.eResource();
    }

    public List<Object> proposals(EObject eObject, EStructuralFeature feature) {
        List<Object> proposals = this.polymorphicCreateProposals(eObject, feature);
        if (proposals != null) {
            return proposals;
        }
        if (this.getResource() == null) {
            this.retrieveResource(eObject);
        }
        return this.defaultProposals(feature);
    }

    protected List<Object> defaultProposals(EStructuralFeature feature) {
        List<Object> retVal = null;
        if (feature instanceof EReference) {
            retVal = this.findAllInstances(feature.getEType());
        } else if (feature.getEType() instanceof EEnumImpl) {
            EEnum eEnum = (EEnum)feature.getEType();
            ArrayList<Object> enumerators = new ArrayList<Object>();
            Iterator iter = eEnum.getELiterals().iterator();
            while (iter.hasNext()) {
                Enumerator instance = ((EEnumLiteral)iter.next()).getInstance();
                enumerators.add(instance);
            }
            retVal = enumerators;
        }
        return retVal;
    }

    protected List<Object> findAllInstances(EClassifier type) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (this.getResource() == null) {
            return objects;
        }
        TreeIterator<Object> allContents = this.getAllContents();
        while (allContents.hasNext()) {
            Object o = allContents.next();
            if (!type.isInstance(o)) continue;
            objects.add(o);
        }
        return objects;
    }

    protected TreeIterator<Object> getAllContents() {
        ResourceSet resourceSet = this.resource.getResourceSet();
        if (resourceSet == null) {
            return EcoreUtil.getAllContents((Resource)this.resource, (boolean)true);
        }
        return EcoreUtil.getAllContents((Collection)resourceSet.getResources(), (boolean)true);
    }

    private List<Object> polymorphicCreateProposals(EObject element, EStructuralFeature feature) {
        EClass eClass = element.eClass();
        List invoke = (List)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)this, (EClass)eClass, (EStructuralFeature)feature, (String)PROPOSALS_PREFIX, (Object[])new Object[]{element, feature});
        if (invoke == null) {
            invoke = (List)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)this, (EClass)eClass, (EStructuralFeature)feature, (String)PROPOSALS_PREFIX, (Object[])new Object[]{element});
        }
        return invoke;
    }
}

