/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDODeltaNotification;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.internal.ui.actions.RemoveAllContainerItemAction;
import org.eclipse.emf.cdo.internal.ui.actions.RemoveContainerItemAction;
import org.eclipse.emf.cdo.internal.ui.dnd.CDOObjectDropAdapter;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class CDOWatchListView
extends ViewPart
implements ISelectionProvider {
    private static final String[] columnNames = new String[]{Messages.getString("CDOWatchListView.0"), Messages.getString("CDOWatchListView.1"), Messages.getString("CDOWatchListView.2"), Messages.getString("CDOWatchListView.3")};
    private static final int[] columnWidths = new int[]{110, 280, 170, 230};
    public static final String ID = "org.eclipse.emf.cdo.ui.CDOWatchListView";
    private final ComposedAdapterFactory adapterFactory;
    private final CDOObjectContainer container = new CDOObjectContainer();
    private final WatchedObjectsDataRegistry dataRegistry = new WatchedObjectsDataRegistry();
    private TableViewer viewer;
    private IPropertySheetPage propertySheetPage;
    private IAction removeAction;
    private IAction removeAllAction;
    private IAction resetNotificationAction;
    private IAction resetAllNotificationAction;

    public CDOWatchListView() {
        this.adapterFactory = CDOEditor.createAdapterFactory(true);
        this.container.addListener(this.getDataRegistry());
    }

    public void dispose() {
        this.adapterFactory.dispose();
        super.dispose();
    }

    public WatchedObjectsDataRegistry getDataRegistry() {
        return this.dataRegistry;
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        IListener refreshListener = new IListener(){

            public void notifyEvent(IEvent event) {
                UIUtil.refreshViewer((Viewer)CDOWatchListView.this.viewer);
            }
        };
        this.container.addListener(refreshListener);
        this.getDataRegistry().addListener(refreshListener);
        this.createActions();
        this.createToolbarButtons();
        this.createContextMenu();
        this.hookKeyboardActions();
        this.createViewPulldownMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    private void createActions() {
        ISharedImages platformImages = PlatformUI.getWorkbench().getSharedImages();
        this.removeAction = new RemoveContainerItemAction<CDOObject>(this.container, (ISelectionProvider)this.viewer);
        this.removeAction.setText(Messages.getString("CDOWatchListView.4"));
        this.removeAction.setImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeAction.setDisabledImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.removeAction.setToolTipText(Messages.getString("CDOWatchListView.5"));
        this.removeAllAction = new RemoveAllContainerItemAction<CDOObject>(this.container);
        this.removeAllAction.setText(Messages.getString("CDOWatchListView.6"));
        this.removeAllAction.setImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeAllAction.setToolTipText(Messages.getString("CDOWatchListView.7"));
        this.resetNotificationAction = new ResetNotificationAction();
        this.resetNotificationAction.setText(Messages.getString("CDOWatchListView.8"));
        this.resetNotificationAction.setImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.resetNotificationAction.setDisabledImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        this.resetNotificationAction.setToolTipText(Messages.getString("CDOWatchListView.9"));
        this.resetAllNotificationAction = new ResetAllNotificationAction();
        this.resetAllNotificationAction.setText(Messages.getString("CDOWatchListView.10"));
        this.resetAllNotificationAction.setImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.resetAllNotificationAction.setDisabledImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        this.resetAllNotificationAction.setToolTipText(Messages.getString("CDOWatchListView.11"));
    }

    private void createToolbarButtons() {
        this.getViewSite().getActionBars().getToolBarManager().add(this.resetAllNotificationAction);
    }

    private void createViewPulldownMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.add(this.removeAllAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                CDOWatchListView.this.fillContextMenu(m);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        boolean isEmpty = this.viewer.getSelection().isEmpty();
        this.removeAction.setEnabled(!isEmpty);
        menuMgr.add(this.removeAction);
        this.resetNotificationAction.setEnabled(!isEmpty);
        menuMgr.add(this.resetNotificationAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void hookKeyboardActions() {
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                CDOWatchListView.this.handleKeyReleased(event);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.removeAction.run();
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public ISelection getSelection() {
        if (this.viewer != null) {
            return this.viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(listener);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return (T)this.getPropertySheetPage();
        }
        return (T)super.getAdapter(adapter);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.propertySheetPage = page;
        }
        return this.propertySheetPage;
    }

    private TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 66306);
        viewer.getTable().setLayoutData((Object)UIUtil.createGridData());
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        this.createColumns(viewer.getTable());
        viewer.setContentProvider((IContentProvider)new CDOObjectContainerContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new CDOSubscriptionViewLabelProvider((AdapterFactory)this.adapterFactory));
        viewer.setInput((Object)this.container);
        CDOObjectDropAdapter.support((StructuredViewer)viewer);
        return viewer;
    }

    private void createColumns(Table table) {
        TableColumn[] columns = new TableColumn[columnNames.length];
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384, i);
            column.setText(columnNames[i]);
            column.setWidth(columnWidths[i]);
            column.setMoveable(true);
            column.setResizable(true);
            ++i;
        }
    }

    private final class CDOObjectContainer
    extends Container<CDOObject>
    implements IContainer.Modifiable<CDOObject> {
        private Set<CDOObject> watchedObjects = new HashSet<CDOObject>();
        private CDOSubscriptionAdapter subscriptionAdapter;
        private ViewDeactivationListener viewDeactivationListener;
        private TransactionHandler transactionHandler;
        private CDOViewReferenceCounterManager counterManager;

        public CDOObjectContainer() {
            this.subscriptionAdapter = new CDOSubscriptionAdapter();
            this.viewDeactivationListener = new ViewDeactivationListener();
            this.transactionHandler = new TransactionHandler();
            this.counterManager = new CDOViewReferenceCounterManager();
        }

        public CDOObject[] getElements() {
            return this.watchedObjects.toArray(new CDOObject[this.watchedObjects.size()]);
        }

        public boolean isEmpty() {
            return this.watchedObjects.isEmpty();
        }

        public boolean addElement(CDOObject element) {
            if (this.watchedObjects.add(element)) {
                this.postAdd(element);
                this.fireElementAddedEvent(element);
                return true;
            }
            return false;
        }

        public boolean removeElement(CDOObject element) {
            if (this.watchedObjects.remove(element)) {
                this.postRemove(element);
                this.fireElementRemovedEvent(element);
                return true;
            }
            return false;
        }

        public boolean addAllElements(Collection<CDOObject> elements) {
            ArrayList<CDOObject> addedElements = new ArrayList<CDOObject>();
            for (CDOObject cdoObject : elements) {
                if (!this.watchedObjects.add(cdoObject)) continue;
                this.postAdd(cdoObject);
                addedElements.add(cdoObject);
            }
            if (!addedElements.isEmpty()) {
                this.fireElementsAddedEvent(addedElements.toArray(new CDOObject[addedElements.size()]));
                return true;
            }
            return false;
        }

        public boolean removeAllElements(Collection<CDOObject> elements) {
            ArrayList<CDOObject> removedElements = new ArrayList<CDOObject>();
            for (CDOObject cdoObject : elements) {
                if (!this.watchedObjects.remove(cdoObject)) continue;
                this.postRemove(cdoObject);
                removedElements.add(cdoObject);
            }
            if (!removedElements.isEmpty()) {
                this.fireElementsRemovedEvent(removedElements.toArray(new CDOObject[removedElements.size()]));
                return true;
            }
            return false;
        }

        private void postAdd(CDOObject element) {
            element.cdoView().options().addChangeSubscriptionPolicy((CDOAdapterPolicy)this.subscriptionAdapter);
            element.eAdapters().add((Object)this.subscriptionAdapter);
            this.increaseViewReference(element);
        }

        private void postRemove(CDOObject element) {
            this.decreaseViewReference(element);
            CDOView view = element.cdoView();
            if (view != null && !view.isClosed()) {
                element.eAdapters().remove((Object)this.subscriptionAdapter);
            }
        }

        private void increaseViewReference(CDOObject referrer) {
            CDOViewReferenceCounterManager.CDOViewReferenceCounter counter = this.counterManager.getCounter(referrer);
            if (counter.increase() == 1L) {
                CDOView view = referrer.cdoView();
                view.addListener((IListener)this.viewDeactivationListener);
                if (view instanceof CDOTransaction) {
                    ((CDOTransaction)view).addTransactionHandler((CDOTransactionHandlerBase)this.transactionHandler);
                }
            }
        }

        private void decreaseViewReference(CDOObject referrer) {
            CDOViewReferenceCounterManager.CDOViewReferenceCounter counter = this.counterManager.getCounter(referrer);
            if (counter.decrease() == 0L && referrer.cdoView() != null) {
                CDOView view = referrer.cdoView();
                view.removeListener((IListener)this.viewDeactivationListener);
                if (view instanceof CDOTransaction) {
                    ((CDOTransaction)view).removeTransactionHandler((CDOTransactionHandlerBase)this.transactionHandler);
                }
            }
        }

        private final class ViewDeactivationListener
        implements IListener {
            private ViewDeactivationListener() {
            }

            public void notifyEvent(IEvent event) {
                if (event instanceof ILifecycleEvent && ((ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.ABOUT_TO_DEACTIVATE) {
                    ArrayList<CDOObject> aboutToRemove = new ArrayList<CDOObject>();
                    CDOObject[] cDOObjectArray = CDOObjectContainer.this.getElements();
                    int n = cDOObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CDOObject object = cDOObjectArray[n2];
                        if (object.cdoView().equals(event.getSource())) {
                            aboutToRemove.add(object);
                        }
                        ++n2;
                    }
                    CDOObjectContainer.this.removeAllElements(aboutToRemove);
                }
            }
        }
    }

    private final class CDOObjectContainerContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object object) {
            return ((IContainer)object).getElements();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class CDOSubscriptionAdapter
    extends AdapterImpl
    implements CDOAdapterPolicy {
        public void notifyChanged(Notification msg) {
            if (msg instanceof CDODeltaNotification) {
                this.checkDetached(msg);
                CDOWatchListView.this.getDataRegistry().addNotification(msg);
            }
        }

        private void checkDetached(Notification msg) {
            if (msg.getEventType() == 111) {
                Object obj = msg.getNotifier();
                CDOWatchListView.this.container.removeElement(CDOUtil.getCDOObject((EObject)((EObject)obj)));
                CDOWatchListView.this.getDataRegistry().removeData(obj);
            }
        }

        public boolean isValid(EObject object, Adapter adapter) {
            return adapter instanceof CDOSubscriptionAdapter;
        }
    }

    private final class CDOSubscriptionViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private final Color YELLOW = UIUtil.getDisplay().getSystemColor(7);
        private final String[] eventTypes = new String[]{Messages.getString("CDOWatchListView.12"), Messages.getString("CDOWatchListView.25"), Messages.getString("CDOWatchListView.26"), Messages.getString("CDOWatchListView.27"), Messages.getString("CDOWatchListView.28"), Messages.getString("CDOWatchListView.29"), Messages.getString("CDOWatchListView.30"), Messages.getString("CDOWatchListView.31"), Messages.getString("CDOWatchListView.32"), Messages.getString("CDOWatchListView.33")};
        private AdapterFactory adapterFactory;

        public CDOSubscriptionViewLabelProvider(AdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (FSMUtil.isInvalid((CDOObject)CDOUtil.getCDOObject((EObject)((EObject)object)))) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
                    if (labelProvider == null) break;
                    return ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(object));
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            CDOObject object = CDOUtil.getCDOObject((EObject)((EObject)element));
            if (FSMUtil.isInvalid((CDOObject)object)) {
                return object.cdoState().toString();
            }
            switch (columnIndex) {
                case 0: {
                    IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
                    if (labelProvider != null) {
                        return labelProvider.getText((Object)object);
                    }
                    return null;
                }
                case 1: {
                    return object.cdoResource().getURI().toString();
                }
                case 2: {
                    return "?";
                }
                case 3: {
                    Notification notification = CDOWatchListView.this.getDataRegistry().getNotification(element);
                    return this.createEventLabel(notification);
                }
            }
            return element.toString();
        }

        public Color getBackground(Object element) {
            if (element instanceof CDOObject && CDOWatchListView.this.getDataRegistry().getNotification(element) != null) {
                return this.YELLOW;
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        private String createEventLabel(Notification notification) {
            if (notification == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            int event = notification.getEventType();
            if (event < 10) {
                builder.append(this.eventTypes[event]);
            }
            builder.append(": ");
            builder.append(((EStructuralFeature)notification.getFeature()).getName());
            builder.append(" = ");
            builder.append(notification.getNewValue().toString());
            return builder.toString();
        }
    }

    private final class CDOViewReferenceCounterManager {
        private List<CDOViewReferenceCounter> viewReferences = new ArrayList<CDOViewReferenceCounter>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOViewReferenceCounter getCounter(CDOObject cdoObject) {
            List<CDOViewReferenceCounter> list = this.viewReferences;
            synchronized (list) {
                for (CDOViewReferenceCounter counter : this.viewReferences) {
                    if (!counter.getReferencedView().equals(cdoObject.cdoView())) continue;
                    return counter;
                }
            }
            CDOViewReferenceCounter counter = new CDOViewReferenceCounter(cdoObject);
            this.viewReferences.add(counter);
            return counter;
        }

        private class CDOViewReferenceCounter {
            private final CDOView view;
            private AtomicLong referenceCount = new AtomicLong();

            public CDOViewReferenceCounter(CDOObject cdoObject) {
                this.view = cdoObject.cdoView();
                this.referenceCount.set(0L);
            }

            public long increase() {
                return this.referenceCount.incrementAndGet();
            }

            public synchronized long decrease() {
                Long value = this.referenceCount.decrementAndGet();
                if (value == 0L) {
                    CDOViewReferenceCounterManager.this.viewReferences.remove(this);
                }
                return value;
            }

            public CDOView getReferencedView() {
                return this.view;
            }
        }
    }

    private final class ResetAllNotificationAction
    extends LongRunningAction {
        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            ArrayList<Object> aboutToReset = new ArrayList<Object>();
            CDOObject[] cDOObjectArray = CDOWatchListView.this.container.getElements();
            int n = cDOObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOObject cdoObject = cDOObjectArray[n2];
                aboutToReset.add(cdoObject);
                ++n2;
            }
            CDOWatchListView.this.getDataRegistry().removeAllNotification(aboutToReset);
        }
    }

    private final class ResetNotificationAction
    extends LongRunningAction {
        private transient List<?> targets;

        protected void preRun() throws Exception {
            IStructuredSelection ssel;
            ISelection selection = CDOWatchListView.this.getSelection();
            if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
                this.targets = ssel.toList();
                return;
            }
            this.cancel();
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            if (this.targets != null) {
                List<?> useTargets = this.targets;
                this.targets = null;
                for (Object object : useTargets) {
                    if (!(object instanceof CDOObject)) continue;
                    CDOWatchListView.this.getDataRegistry().removeNotification(object);
                }
            }
        }
    }

    private final class TransactionHandler
    extends CDODefaultTransactionHandler2 {
        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            CDOWatchListView.this.container.removeAllElements(commitContext.getDetachedObjects().values());
            UIUtil.refreshViewer((Viewer)CDOWatchListView.this.viewer);
        }
    }

    private final class WatchedObjectsDataRegistry
    extends org.eclipse.net4j.util.event.Notifier
    implements IListener {
        private Map<Object, WatchedObjectData> registry = new HashMap<Object, WatchedObjectData>();
        private final IEvent dataRegistryEvent = new IEvent(){

            public INotifier getSource() {
                return WatchedObjectsDataRegistry.this;
            }
        };

        public WatchedObjectData getData(Object object) {
            WatchedObjectData data = this.registry.get(object);
            if (data == null) {
                data = new WatchedObjectData();
                this.registry.put(object, data);
            }
            return data;
        }

        public void addNotification(Notification msg) {
            this.getData(msg.getNotifier()).setNotification(msg);
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(this.dataRegistryEvent, listeners);
            }
        }

        public void removeNotification(Object object) {
            this.getData(object).deleteNotification();
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(this.dataRegistryEvent, listeners);
            }
        }

        public void removeData(Object object) {
            this.registry.remove(object);
        }

        public void removeAllNotification(Collection<Object> objects) {
            for (WatchedObjectData data : this.registry.values()) {
                data.deleteNotification();
            }
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(this.dataRegistryEvent, listeners);
            }
        }

        public Notification getNotification(Object object) {
            return this.getData(object).getNotification();
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof ContainerEvent) {
                ContainerEvent containerEvent = (ContainerEvent)event;
                IContainerDelta[] iContainerDeltaArray = containerEvent.getDeltas();
                int n = iContainerDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainerDelta delta = iContainerDeltaArray[n2];
                    if (delta.getKind().equals((Object)IContainerDelta.Kind.REMOVED)) {
                        this.removeData(delta.getElement());
                    }
                    ++n2;
                }
            }
        }

        private final class WatchedObjectData {
            private Notification notification;

            public void setNotification(Notification notification) {
                this.notification = notification;
            }

            public void deleteNotification() {
                this.notification = null;
            }

            public Notification getNotification() {
                return this.notification;
            }
        }
    }
}

