/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.common.revision.AbstractCDORevisionCache;
import org.eclipse.emf.cdo.internal.common.revision.CacheAdditionEvent;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.event.IListener;

public class CDORevisionCacheNonAuditing
extends AbstractCDORevisionCache {
    private Map<CDOID, Reference<InternalCDORevision>> revisions = CDOIDUtil.createMap();

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new CDORevisionCacheNonAuditing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EClass getObjectType(CDOID id) {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            InternalCDORevision revision;
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null && (revision = ref.get()) != null) {
                return revision.getEClass();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        this.checkBranch(branchPoint.getBranch());
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            InternalCDORevision revision;
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null && (revision = ref.get()) != null && revision.isValid(branchPoint)) {
                return revision;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        this.checkBranch(branchVersion.getBranch());
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            InternalCDORevision revision;
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null && (revision = ref.get()) != null && revision.getVersion() == branchVersion.getVersion()) {
                return revision;
            }
            return null;
        }
    }

    @Override
    public void forEachCurrentRevision(Consumer<CDORevision> consumer) {
        this.forEachRevision(r -> {
            if (!r.isHistorical()) {
                consumer.accept((CDORevision)r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachRevision(Consumer<CDORevision> consumer) {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            for (Reference<InternalCDORevision> ref : this.revisions.values()) {
                InternalCDORevision revision = ref.get();
                if (revision == null) continue;
                consumer.accept(revision);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            ArrayList<InternalCDORevision> list = new ArrayList<InternalCDORevision>();
            for (Reference<InternalCDORevision> ref : this.revisions.values()) {
                InternalCDORevision revision = ref.get();
                if (revision == null) continue;
                list.add(revision);
            }
            if (!list.isEmpty()) {
                result.put(((CDORevision)list.get(0)).getBranch(), list);
            }
        }
        return result;
    }

    @Override
    public void getAllRevisions(List<InternalCDORevision> result) {
        for (Reference<InternalCDORevision> ref : this.revisions.values()) {
            InternalCDORevision revision = ref.get();
            if (revision == null) continue;
            result.add(revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        this.checkBranch(branchPoint.getBranch());
        ArrayList<CDORevision> result = new ArrayList<CDORevision>();
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            for (Reference<InternalCDORevision> ref : this.revisions.values()) {
                InternalCDORevision revision = ref.get();
                if (revision == null || !revision.isValid(branchPoint)) continue;
                result.add(revision);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDORevision internRevision(CDORevision revision) {
        CheckUtil.checkArg((Object)revision, (String)"revision");
        this.checkBranch(revision.getBranch());
        if (!revision.isHistorical()) {
            CDOID id = revision.getID();
            CDORevision passedRevision = revision;
            IListener[] listeners = this.getListeners();
            CacheAdditionEvent[] event = new CacheAdditionEvent[1];
            Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
            synchronized (map) {
                try {
                    this.revisions.compute(id, (k, cachedReference) -> {
                        InternalCDORevision cachedRevision;
                        if (cachedReference != null && (cachedRevision = (InternalCDORevision)cachedReference.get()) != null) {
                            if (cachedRevision.getVersion() > passedRevision.getVersion()) {
                                throw new CollectionUtil.KeepMappedValue((Object)passedRevision);
                            }
                            if (cachedRevision.equals(passedRevision)) {
                                throw new CollectionUtil.KeepMappedValue((Object)cachedRevision);
                            }
                        }
                        if (listeners.length != 0) {
                            cacheAdditionEventArray[0] = new CacheAdditionEvent(this, passedRevision);
                        }
                        return this.createReference(passedRevision);
                    });
                }
                catch (CollectionUtil.KeepMappedValue ex) {
                    revision = (CDORevision)ex.mappedValue();
                }
            }
            this.fireEvent(event[0], listeners);
        }
        return revision;
    }

    @Override
    public void removeRevisions(CDOBranch ... branches) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InternalCDORevision doRemoveRevision(CDOID id, CDOBranchVersion branchVersion) {
        this.checkBranch(branchVersion.getBranch());
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            Reference<InternalCDORevision> ref = this.revisions.get(id);
            if (ref != null) {
                InternalCDORevision revision = ref.get();
                if (revision != null) {
                    if (revision.getVersion() == branchVersion.getVersion()) {
                        this.revisions.remove(id);
                        return revision;
                    }
                } else {
                    this.revisions.remove(id);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<CDOID, Reference<InternalCDORevision>> map = this.revisions;
        synchronized (map) {
            this.revisions.clear();
        }
    }
}

