/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class PartitionDoubleClickSelector
extends DefaultTextDoubleClickStrategy {
    private String fPartitioning;
    int fLeftBorder;
    int fRightBorder;
    int fHitDelta;

    public PartitionDoubleClickSelector(String partitioning, int leftBorder, int rightBorder) {
        this(partitioning, leftBorder, rightBorder, 1);
    }

    public PartitionDoubleClickSelector(String partitioning, int leftBorder, int rightBorder, int hitDeltaOffset) {
        this.fPartitioning = partitioning;
        this.fLeftBorder = leftBorder;
        this.fRightBorder = rightBorder;
        this.fHitDelta = hitDeltaOffset;
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion match = super.findExtendedDoubleClickSelection(document, offset);
        if (match != null) {
            return match;
        }
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)offset, (boolean)true);
            if (offset == region.getOffset() + this.fHitDelta || offset == region.getOffset() + region.getLength() - this.fHitDelta) {
                if (this.fLeftBorder == 0 && this.fRightBorder == 0) {
                    return region;
                }
                if (this.fRightBorder == -1) {
                    String delimiter = document.getLineDelimiter(document.getLineOfOffset(region.getOffset() + region.getLength() - 1));
                    this.fRightBorder = delimiter == null ? 0 : delimiter.length();
                }
                return new Region(region.getOffset() + this.fLeftBorder, region.getLength() - this.fLeftBorder - this.fRightBorder);
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        return null;
    }
}

