/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.console;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.ScriptConsoleServer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.console.TclInterpreter;
import org.eclipse.dltk.tcl.launching.TclLaunchingPlugin;

public class TclConsoleUtil {
    public static ILaunch runDefaultTclInterpreter(TclInterpreter interpreter) throws CoreException, IOException {
        ConsoleDeployment deployment = TclConsoleUtil.deployConsoleScript(EnvironmentManager.getLocalEnvironment());
        if (deployment == null) {
            return null;
        }
        ILaunch launch = ScriptLaunchUtil.runScript((String)"org.eclipse.dltk.tcl.core.nature", (IFileHandle)deployment.scriptFile, null, null, (String[])TclConsoleUtil.constructConsoleArgs(interpreter), null);
        TclConsoleUtil.registerForCleanup(launch, deployment, interpreter);
        return launch;
    }

    public static ILaunch runTclInterpreter(IInterpreterInstall install, TclInterpreter interpreter) throws CoreException, IOException {
        ConsoleDeployment deployment = TclConsoleUtil.deployConsoleScript(install.getEnvironment());
        if (deployment == null) {
            return null;
        }
        ILaunch launch = ScriptLaunchUtil.runScript((IInterpreterInstall)install, (IFileHandle)deployment.scriptFile, null, null, (String[])TclConsoleUtil.constructConsoleArgs(interpreter), null);
        TclConsoleUtil.registerForCleanup(launch, deployment, interpreter);
        return launch;
    }

    private static ConsoleDeployment deployConsoleScript(IEnvironment environment) throws IOException {
        IExecutionEnvironment exeEnv = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        IDeployment deployment = exeEnv.createDeployment();
        if (deployment == null) {
            return null;
        }
        IPath path = deployment.add(TclLaunchingPlugin.getDefault().getBundle(), TclLaunchingPlugin.getDefault().getConsoleProxy());
        return new ConsoleDeployment(deployment, deployment.getFile(path));
    }

    private static String[] constructConsoleArgs(TclInterpreter interpreter) {
        ScriptConsoleServer server = ScriptConsoleServer.getInstance();
        return new String[]{DLTKDebugPlugin.getDefault().getBindAddress(), Integer.toString(server.getPort()), server.register((ConsoleRequest)interpreter)};
    }

    private static void registerForCleanup(ILaunch launch, ConsoleDeployment deployment, TclInterpreter interpreter) {
        if (launch == null) {
            return;
        }
        DeploymentManager.getInstance().addDeployment(launch, deployment.deployment);
        interpreter.addCloseOperation(() -> {
            IProcess[] processes = launch.getProcesses();
            if (processes != null) {
                int i = 0;
                while (i < processes.length) {
                    block4: {
                        try {
                            processes[i].terminate();
                        }
                        catch (DebugException e) {
                            if (!DLTKCore.DEBUG) break block4;
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
        });
    }

    private static class ConsoleDeployment {
        final IFileHandle scriptFile;
        final IDeployment deployment;

        public ConsoleDeployment(IDeployment deployment, IFileHandle scriptFile) {
            this.deployment = deployment;
            this.scriptFile = scriptFile;
        }
    }
}

