/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIBreakInsertInfo
extends MIInfo {
    MIBreakpoint[] breakpoints = null;

    public MIBreakInsertInfo(MIOutput record) {
        super(record);
        MIResultRecord rr;
        ArrayList<MIBreakpoint> aList = new ArrayList<MIBreakpoint>(1);
        if (this.isDone() && (rr = record.getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue val = results[i].getMIValue();
                MIBreakpoint bpt = null;
                if (var.equals("wpt")) {
                    if (val instanceof MITuple) {
                        bpt = this.createMIBreakpoint((MITuple)val);
                        bpt.setEnabled(true);
                        bpt.setWriteWatchpoint(true);
                    }
                } else if (var.equals("bkpt")) {
                    if (val instanceof MITuple) {
                        bpt = this.createMIBreakpoint((MITuple)val);
                    }
                } else if (var.equals("hw-awpt")) {
                    if (val instanceof MITuple) {
                        bpt = this.createMIBreakpoint((MITuple)val);
                        bpt.setAccessWatchpoint(true);
                        bpt.setEnabled(true);
                    }
                } else if (var.equals("hw-rwpt") && val instanceof MITuple) {
                    bpt = this.createMIBreakpoint((MITuple)val);
                    bpt.setReadWatchpoint(true);
                    bpt.setEnabled(true);
                }
                if (bpt != null) {
                    aList.add(bpt);
                }
                ++i;
            }
        }
        this.breakpoints = aList.toArray(new MIBreakpoint[aList.size()]);
    }

    public MIBreakpoint[] getMIBreakpoints() {
        return this.breakpoints;
    }

    protected MIBreakpoint createMIBreakpoint(MITuple tuple) {
        return new MIBreakpoint(tuple);
    }
}

