/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.util.Date;
import java.util.Locale;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;

public class CDateTime
extends GregorianCalendar {
    private static final long serialVersionUID = 1L;
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int MILLIS_IN_MINUTE = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_DAY = 86400000;
    private static final int[] iaUnitTypes = new int[]{14, 13, 12, 11, 5, 3, 2, 1};
    public static final int QUARTER = 999;
    public static final int WEEK_OF_QUARTER = 1001;
    public static final int DAY_OF_QUARTER = 1002;
    private static int[] iaCalendarUnits = new int[]{13, 12, 11, 5, 2, 999};
    private static final SimpleDateFormat _sdf = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");
    private boolean bTimeOnly = false;
    private boolean bDateOnly = false;

    public CDateTime() {
    }

    public CDateTime(Date d) {
        this.setTime(d);
        this.checkDateType(d);
    }

    public CDateTime(Calendar c) {
        if (c != null) {
            this.setTime(c.getTime());
            if (c instanceof CDateTime) {
                this.checkDateType((CDateTime)c);
                if (((CDateTime)c).isFullDateTime()) {
                    this.setTimeZone(c.getTimeZone());
                }
            }
        }
    }

    public CDateTime(long lTimeInMillis) {
        this.setTimeInMillis(lTimeInMillis);
    }

    public CDateTime(int year, int month, int date) {
        super(year, month - 1, date);
    }

    public CDateTime(int year, int month, int date, int hour, int minute) {
        super(year, month - 1, date, hour, minute);
    }

    public CDateTime(int year, int month, int date, int hour, int minute, int second) {
        super(year, month - 1, date, hour, minute, second);
    }

    @Deprecated
    public CDateTime(Locale aLocale) {
        super(aLocale);
    }

    public CDateTime(ULocale locale) {
        super(locale);
    }

    public CDateTime(TimeZone tz) {
        super(tz);
    }

    @Deprecated
    public CDateTime(TimeZone tz, Locale locale) {
        super(tz, locale);
    }

    public CDateTime(TimeZone tz, ULocale locale) {
        super(tz, locale);
    }

    public CDateTime backward(int iUnit, int iStep) {
        CDateTime cd = (CDateTime)((Object)this.clone());
        if (iUnit == 999) {
            cd.add(2, (iStep == 0 ? 1 : iStep) * -3);
        } else {
            cd.add(iUnit, -iStep);
        }
        return cd;
    }

    public CDateTime forward(int iUnit, int iStep) {
        CDateTime cd = (CDateTime)((Object)this.clone());
        if (iUnit == 999) {
            cd.add(2, (iStep == 0 ? 1 : iStep) * 3);
        } else {
            cd.add(iUnit, iStep);
        }
        return cd;
    }

    public final int getYear() {
        return this.get(1);
    }

    public final int getMonth() {
        return this.get(2);
    }

    public final int getDay() {
        return this.get(5);
    }

    public final int getHour() {
        return this.get(11);
    }

    public final int getMinute() {
        return this.get(12);
    }

    public final int getSecond() {
        return this.get(13);
    }

    public static final int getDifference(CDateTime cdt1, CDateTime cdt2) {
        if (cdt1.getYear() != cdt2.getYear()) {
            return 1;
        }
        if (cdt1.getMonth() != cdt2.getMonth()) {
            return 2;
        }
        if (cdt1.getDay() != cdt2.getDay()) {
            return 5;
        }
        if (cdt1.getHour() != cdt2.getHour()) {
            return 11;
        }
        if (cdt1.getMinute() != cdt2.getMinute()) {
            return 12;
        }
        if (cdt1.getSecond() != cdt2.getSecond()) {
            return 13;
        }
        return 0;
    }

    public static final String getPreferredFormat(int iUnit) {
        if (iUnit == 1) {
            return "yyyy";
        }
        if (iUnit == 2) {
            return "MMM yyyy";
        }
        if (iUnit == 5) {
            return "MM-dd-yyyy";
        }
        if (iUnit == 11) {
            return "MM-dd-yy\nHH:mm";
        }
        if (iUnit == 12) {
            return "HH:mm:ss";
        }
        if (iUnit == 13) {
            return "HH:mm:ss";
        }
        return null;
    }

    public static final int getPreferredUnit(CDateTime minDateTime, CDateTime maxDateTime) {
        if (minDateTime.equals((Object)maxDateTime)) {
            int i = 0;
            while (i < iaCalendarUnits.length) {
                int pUnit = iaCalendarUnits[i];
                if (minDateTime.get(pUnit) > 0) {
                    return pUnit;
                }
                ++i;
            }
            return 1;
        }
        int i = 0;
        while (i < iaCalendarUnits.length) {
            int pUnit = iaCalendarUnits[i];
            if (CDateTime.computeDifference(maxDateTime, minDateTime, pUnit) <= 95.0) {
                return pUnit;
            }
            ++i;
        }
        return 1;
    }

    public static final double computeDifference(CDateTime cdt1, CDateTime cdt2, int iUnit) {
        return CDateTime.computeDifference(cdt1, cdt2, iUnit, false);
    }

    public static final double computeDifference(CDateTime cdt1, CDateTime cdt2, int iUnit, boolean trimBelow) {
        long l1 = cdt1.getTimeInMillis();
        long l2 = cdt2.getTimeInMillis();
        if (iUnit == 14) {
            double rt = l1 - l2;
            if (trimBelow) {
                rt = Math.floor(rt);
            }
            return rt;
        }
        if (iUnit == 13) {
            double rt = (double)(l1 - l2) / 1000.0;
            if (trimBelow) {
                rt = Math.floor(rt);
            }
            return rt;
        }
        if (iUnit == 12) {
            double rt = (double)(l1 - l2) / 60000.0;
            if (trimBelow) {
                rt = Math.floor(rt);
            }
            return rt;
        }
        if (iUnit == 11 || iUnit == 10) {
            double rt = (double)(l1 - l2) / 3600000.0;
            if (trimBelow) {
                rt = Math.floor(rt);
            }
            return rt;
        }
        if (iUnit == 5) {
            double rt = (double)(l1 - l2) / 8.64E7;
            if (trimBelow) {
                rt = Math.floor(rt);
            }
            return rt;
        }
        if (iUnit == 3) {
            double dDays = CDateTime.computeDifference(cdt1, cdt2, 5);
            double rt = dDays / 7.0;
            if (trimBelow) {
                rt = Math.floor(rt);
            }
            return rt;
        }
        if (iUnit == 2) {
            if (trimBelow) {
                double dYears = cdt1.getYear() - cdt2.getYear();
                return dYears * 12.0 + (double)(cdt1.getMonth() - cdt2.getMonth());
            }
            double dDays = CDateTime.computeDifference(cdt1, cdt2, 5);
            return dDays / 30.4375;
        }
        if (iUnit == 1) {
            if (trimBelow) {
                return cdt1.getYear() - cdt2.getYear();
            }
            double dDays = CDateTime.computeDifference(cdt1, cdt2, 5);
            return dDays / 365.25;
        }
        if (iUnit == 999) {
            int maxQuarter = cdt1.getYear() * 4 + CDateTime.numberOfQuarter(cdt1);
            int minQuarter = cdt2.getYear() * 4 + CDateTime.numberOfQuarter(cdt2);
            return maxQuarter - minQuarter;
        }
        return 0.0;
    }

    private static int numberOfQuarter(CDateTime d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        int month = d.getMonth();
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private static final int getDefaultUnit(CDateTime c) {
        if (c.isTimeOnly()) {
            return 13;
        }
        if (c.isFullDateTime()) {
            return 14;
        }
        return 5;
    }

    public static final int computeUnit(DataSetIterator dsi) {
        if (dsi.size() == 1) {
            dsi.reset();
            Object value = dsi.next();
            if (value instanceof CDateTime) {
                return CDateTime.getDefaultUnit((CDateTime)((Object)value));
            }
        }
        int k = 0;
        while (k < iaUnitTypes.length) {
            Calendar cPrev = (Calendar)dsi.last();
            dsi.reset();
            while (dsi.hasNext()) {
                Calendar cCurr = (Calendar)dsi.next();
                if (cCurr != null && cPrev != null && cCurr.get(iaUnitTypes[k]) != cPrev.get(iaUnitTypes[k])) {
                    return iaUnitTypes[k];
                }
                if (cCurr == null) continue;
                cPrev = cCurr;
            }
            ++k;
        }
        return 5;
    }

    public static final int computeUnit(CDateTime[] cdta) throws ChartException {
        if (cdta.length == 1) {
            return CDateTime.getDefaultUnit(cdta[0]);
        }
        int k = 0;
        while (k < iaUnitTypes.length) {
            int i = 0;
            while (i < cdta.length) {
                int j = i + 1;
                if (j > cdta.length - 1) {
                    j = 0;
                }
                if (cdta[i] == null || cdta[j] == null) {
                    throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle());
                }
                if (cdta[i].get(iaUnitTypes[k]) != cdta[j].get(iaUnitTypes[k])) {
                    return iaUnitTypes[k];
                }
                ++i;
            }
            ++k;
        }
        return 1;
    }

    public static final int getMaximumDaysIn(int iMonth, int iYear) {
        CDateTime cdt = new CDateTime();
        cdt.set(1, iYear);
        cdt.set(2, iMonth);
        return cdt.getActualMaximum(5);
    }

    public static final int getMaximumDaysIn(int iYear) {
        CDateTime cdt = new CDateTime();
        cdt.set(1, iYear);
        return cdt.getActualMaximum(6);
    }

    public static final double inMillis(int iUnit) {
        if (iUnit == 13) {
            return 1000.0;
        }
        if (iUnit == 12) {
            return 60000.0;
        }
        if (iUnit == 10) {
            return 3600000.0;
        }
        if (iUnit == 5) {
            return 8.64E7;
        }
        if (iUnit == 2) {
            return 2.6298E9;
        }
        if (iUnit == 1) {
            return 3.15576E10;
        }
        return 0.0;
    }

    public final void clearBelow(int iUnit) {
        this.clearBelow(iUnit, false);
    }

    public final void clearBelow(int iUnit, boolean always) {
        if (!always && this.isFullDateTime()) {
            return;
        }
        if (iUnit == 1) {
            this.set(14, 0);
            this.set(13, 0);
            this.set(12, 0);
            this.set(10, 0);
            this.set(5, 1);
            this.set(9, 0);
            this.set(2, 0);
        } else if (iUnit == 2 || iUnit == 999) {
            this.set(14, 0);
            this.set(13, 0);
            this.set(12, 0);
            this.set(10, 0);
            this.set(9, 0);
            this.set(5, 1);
            if (iUnit == 999) {
                this.set(2, this.getMonth() / 3 * 3);
            }
        } else if (iUnit == 3 || iUnit == 4) {
            this.set(14, 0);
            this.set(13, 0);
            this.set(12, 0);
            this.set(10, 0);
            this.set(9, 0);
            int weekDay = this.get(7);
            this.add(5, 1 - weekDay);
        } else if (iUnit == 1001) {
            this.set(14, 0);
            this.set(13, 0);
            this.set(12, 0);
            this.set(10, 0);
            this.set(9, 0);
        } else if (iUnit == 5 || iUnit == 5 || iUnit == 7 || iUnit == 1002 || iUnit == 6) {
            this.set(14, 0);
            this.set(13, 0);
            this.set(12, 0);
            this.set(10, 0);
            this.set(9, 0);
        } else if (iUnit == 10 || iUnit == 11) {
            this.set(14, 0);
            this.set(13, 0);
            this.set(12, 0);
        } else if (iUnit == 12) {
            this.set(14, 0);
            this.set(13, 0);
        } else if (iUnit == 13) {
            this.set(14, 0);
        }
    }

    public final void clearAbove(int iUnit) {
        this.clearAbove(iUnit, false);
    }

    public final void clearAbove(int iUnit, boolean always) {
        if (!always && this.isFullDateTime()) {
            return;
        }
        if (iUnit == 1) {
            return;
        }
        if (iUnit == 2 || iUnit == 999) {
            this.set(1, 2000);
        } else if (iUnit == 5 || iUnit == 5 || iUnit == 7 || iUnit == 1002 || iUnit == 6) {
            this.set(1, 2000);
        } else if (iUnit == 3 || iUnit == 4 || iUnit == 1001) {
            this.set(1, 2000);
        } else if (iUnit == 11 || iUnit == 10) {
            this.set(1, 2000);
            this.set(2, 0);
            this.set(5, 1);
        } else if (iUnit == 12) {
            this.set(1, 2000);
            this.set(2, 0);
            this.set(5, 1);
            this.set(9, 0);
            this.set(10, 0);
        } else if (iUnit == 13) {
            this.set(1, 2000);
            this.set(2, 0);
            this.set(5, 1);
            this.set(9, 0);
            this.set(10, 0);
            this.set(12, 0);
        }
    }

    public CDateTime getUnitStart(int iUnit) {
        CDateTime cd = new CDateTime((Calendar)this);
        cd.clearBelow(iUnit);
        return cd;
    }

    public static CDateTime parse(String sDateTimeValue) {
        try {
            return new CDateTime(_sdf.parse(sDateTimeValue));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String toString() {
        return _sdf.format(this.getTime());
    }

    public boolean after(Object when) {
        if (when == null) {
            return false;
        }
        return super.after(when);
    }

    public boolean before(Object when) {
        if (when == null) {
            return false;
        }
        return super.before(when);
    }

    public boolean isTimeOnly() {
        return this.bTimeOnly;
    }

    public boolean isFullDateTime() {
        return !this.bTimeOnly && !this.bDateOnly;
    }

    public void setTimeOnly(boolean timeOnly) {
        this.bTimeOnly = timeOnly;
    }

    public void add(int unit, int step) {
        if (unit == 999) {
            super.add(2, (step == 0 ? 1 : step) * 3);
            return;
        }
        super.add(unit, step);
    }

    private void checkDateType(Date d) {
        this.bDateOnly = d instanceof java.sql.Date;
        if (d instanceof Time) {
            this.setTimeOnly(true);
        }
    }

    private void checkDateType(CDateTime d) {
        this.bDateOnly = d.bDateOnly;
        this.setTimeOnly(d.isTimeOnly());
    }

    public Date getDateTime() {
        if (this.bDateOnly) {
            return new java.sql.Date(this.getTime().getTime());
        }
        return this.getTime();
    }
}

