/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xsl.core.model.Parameter;
import org.eclipse.wst.xsl.core.model.Stylesheet;
import org.eclipse.wst.xsl.core.model.Variable;
import org.eclipse.wst.xsl.core.model.XSLElement;
import org.eclipse.wst.xsl.core.model.XSLModelObject;

public class Template
extends XSLElement {
    final List<Variable> variables = new ArrayList<Variable>();
    final List<Parameter> parameters = new ArrayList<Parameter>();

    public Template(Stylesheet stylesheet) {
        super(stylesheet);
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void addVariable(Variable var) {
        this.variables.add(var);
    }

    @Override
    public String getName() {
        return this.getAttributeValue("name");
    }

    public String getMatch() {
        return this.getAttributeValue("match");
    }

    public String getMode() {
        return this.getAttributeValue("mode");
    }

    public String getPriority() {
        return this.getAttributeValue("priority");
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        String name = this.getName();
        if (name != null) {
            return 3 + name.hashCode();
        }
        String match = this.getMatch();
        String mode = this.getMode();
        String priority = this.getPriority();
        if (match != null) {
            int hash = 3 * match.hashCode();
            if (priority != null) {
                hash += 5 * priority.hashCode();
            }
            if (mode != null) {
                hash += 7 * mode.hashCode();
            }
            return 5 + hash;
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Template) {
            Template includedTemplate = (Template)((Object)obj);
            if (!this.matchesByMatchOrName(includedTemplate)) {
                return false;
            }
            String priority1 = this.getPriority();
            String priority2 = includedTemplate.getPriority();
            if (priority1 == null && priority2 == null || priority1 != null && priority1.equals(priority2)) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesByMatchOrName(Template includedTemplate) {
        String name1 = this.getName();
        String match1 = this.getMatch();
        String mode1 = this.getMode();
        String name2 = includedTemplate.getName();
        String match2 = includedTemplate.getMatch();
        String mode2 = includedTemplate.getMode();
        if (name1 != null && name1.equals(name2)) {
            return true;
        }
        return match1 != null && match1.equals(match2) && (mode1 == null && mode2 == null || mode1 != null && mode1.equals(mode2));
    }

    @Override
    public String toString() {
        String name = this.getName();
        String match = this.getMatch();
        return "file=" + this.getStylesheet().getFile() + ", name=" + name + ", match=" + match;
    }

    @Override
    public XSLModelObject.Type getModelType() {
        return XSLModelObject.Type.TEMPLATE;
    }
}

