/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP4201
extends AssertionProcessVisitor {
    private final WSDLValidatorImpl validator;
    private ErrorList errorList = new ErrorList();

    public BP4201(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(Import obj, Object parent, WSDLTraversalContext ctx) {
        if (obj != null && (this.isRelativeURI(obj.getNamespaceURI()) || this.isRelativeURI(obj.getLocationURI()))) {
            this.errorList.add(obj.getNamespaceURI(), obj.getLocationURI());
        }
    }

    @Override
    public void visit(Port obj, Object parent, WSDLTraversalContext ctx) {
        if (obj != null) {
            for (Object e : obj.getExtensibilityElements()) {
                if (!(e instanceof SOAPAddress) || !this.isRelativeURI(((SOAPAddress)e).getLocationURI())) continue;
                this.errorList.add(((SOAPAddress)e).getElementType() + ":" + ((SOAPAddress)e).getLocationURI());
            }
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitImport(true);
        traversal.visitPort(true);
        traversal.ignoreReferences();
        traversal.traverse(definition);
        if (this.errorList.isEmpty()) {
            return this.validator.createAssertionResult(testAssertion, "notApplicable", (String)null);
        }
        this.failureDetail = this.validator.createFailureDetail(String.valueOf(testAssertion.getFailureMessage()) + "\n\n" + this.errorList.toString(), entryContext);
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean isRelativeURI(String s) {
        if (s == null) {
            return false;
        }
        try {
            return !new URI(s).isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

