import { type Disposable, type DocumentUri, type RequestHandler, type TextDocumentContentParams, type TextDocumentContentResult } from 'vscode-languageserver-protocol';
import type { Feature, _RemoteWorkspace } from './server';
/**
 * Shape of the text document content feature
 *
 * @since 3.18.0
 * @proposed
 */
export interface TextDocumentContentFeatureShape {
    textDocumentContent: {
        refresh(uri: DocumentUri): Promise<void>;
        on(handler: RequestHandler<TextDocumentContentParams, TextDocumentContentResult | null, void>): Disposable;
    };
}
export declare const TextDocumentContentFeature: Feature<_RemoteWorkspace, TextDocumentContentFeatureShape>;
