/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public class ProgressIcons {
    private final ImageData initialImageData;
    private final Map<ProgressIconKey, Image> progressIcons = new HashMap<ProgressIconKey, Image>();
    private final Device display;

    public ProgressIcons(Image sourceImage) {
        this.initialImageData = sourceImage.getImageData();
        this.display = sourceImage.getDevice();
    }

    public void dispose() {
        this.progressIcons.values().forEach(Resource::dispose);
        this.progressIcons.clear();
    }

    public Image getImage(int current, Integer total, boolean hasFailures) {
        int totalAsInt = total != null ? total : current + 1;
        int pixelsToDraw = this.initialImageData.width * current / totalAsInt;
        RGB color = this.display.getSystemColor(hasFailures ? 3 : 5).getRGB();
        ProgressIconKey key = new ProgressIconKey(pixelsToDraw, color);
        return this.progressIcons.computeIfAbsent(key, progressKey -> {
            ImageData imageData = (ImageData)this.initialImageData.clone();
            int pixelColorCode = imageData.palette.getPixel(color);
            int line = 4 * imageData.height / 5;
            while (line < imageData.height) {
                int column = 0;
                while (column < pixelsToDraw && column < imageData.width) {
                    imageData.setAlpha(column, line, 255);
                    imageData.setPixel(column, line, pixelColorCode);
                    ++column;
                }
                ++line;
            }
            return new Image(this.display, imageData);
        });
    }

    private static final class ProgressIconKey {
        private final int pixels;
        private final RGB color;

        public ProgressIconKey(int pixels, RGB color) {
            this.pixels = pixels;
            this.color = color;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (!(obj instanceof ProgressIconKey)) {
                return false;
            }
            ProgressIconKey progressIconKey = (ProgressIconKey)obj;
            return this.pixels == other.pixels && Objects.equals(this.color, other.color);
        }

        public int hashCode() {
            return Objects.hash(this.pixels, this.color);
        }
    }
}

