/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStaticMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.IClassMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMembersStrategy;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class ClassFieldsStrategy
extends ClassMembersStrategy {
    private static final String CLASS_KEYWORD = "class";
    private static final String STD_CLASS = "stdClass";
    private static final String ENUM_NAME_FIELD = "$name";
    private static final String ENUM_VALUE_FIELD = "$value";

    public ClassFieldsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassFieldsStrategy(ICompletionContext context) {
        super(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof IClassMemberContext) || !(context instanceof AbstractCompletionContext)) {
            return;
        }
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        IClassMemberContext concreteContext = (IClassMemberContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        String prefix = abstractContext.getPrefix();
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = concreteContext.getLhsTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType = iTypeArray[n2];
            try {
                int n3;
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(iType, null);
                IField[] fields = null;
                if (concreteContext instanceof ClassStaticMemberContext && concreteContext.getTriggerType() == IClassMemberContext.Trigger.CLASS && ((ClassStaticMemberContext)concreteContext).isParent()) {
                    ArrayList<IField> superTypes = new ArrayList<IField>();
                    IType[] iTypeArray2 = hierarchy.getAllSupertypes(iType);
                    int n4 = iTypeArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IType currType = iTypeArray2[n3];
                        superTypes.addAll(Arrays.asList(PHPModelUtils.getTypeField(currType, prefix, requestor.isContextInformationMode())));
                        ++n3;
                    }
                    fields = superTypes.toArray(new IField[superTypes.size()]);
                } else {
                    fields = PHPModelUtils.getTypeHierarchyField(iType, hierarchy, prefix, requestor.isContextInformationMode(), null);
                }
                for (IField field : this.removeOverriddenElements(Arrays.asList(fields))) {
                    if (this.isFiltered((IMember)field, iType, concreteContext)) continue;
                    result.add(field);
                }
                if (concreteContext.getTriggerType() == IClassMemberContext.Trigger.OBJECT && PHPFlags.isEnum(iType.getFlags())) {
                    if (ENUM_NAME_FIELD.startsWith(prefix.toLowerCase()) || ENUM_NAME_FIELD.equals(prefix.toLowerCase())) {
                        result.add((Object)new FakeField((ModelElement)((SourceType)iType), ENUM_NAME_FIELD, 64));
                    }
                    String[] stringArray = iType.getSuperClasses();
                    n3 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n3) {
                        String className = stringArray[n5];
                        if (className.equals("BackedEnum") && ENUM_VALUE_FIELD.startsWith(prefix.toLowerCase()) || ENUM_VALUE_FIELD.equals(prefix.toLowerCase())) {
                            result.add((Object)new FakeField((ModelElement)((SourceType)iType), ENUM_VALUE_FIELD, 64));
                        }
                        ++n5;
                    }
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        if (concreteContext instanceof ClassStaticMemberContext && concreteContext.getTriggerType() == IClassMemberContext.Trigger.CLASS && PHPVersion.PHP5_4.isLessThan(this.getCompanion().getPHPVersion()) && (CLASS_KEYWORD.startsWith(prefix.toLowerCase()) || CLASS_KEYWORD.equals(prefix.toLowerCase()))) {
            try {
                void var9_16;
                ITextRegion iTextRegion = this.getCompanion().getPHPScriptRegion().getPHPToken(this.getCompanion().getPHPToken().getStart() - 1);
                if ("PHP_PAAMAYIM_NEKUDOTAYIM".equals(iTextRegion.getType())) {
                    ITextRegion iTextRegion2 = this.getCompanion().getPHPToken(iTextRegion.getStart() - 1);
                }
                if (this.isStaticCall(var9_16.getType())) {
                    result.add((Object)new FakeField((ModelElement)new FakeType((ModelElement)this.getCompanion().getSourceModule(), STD_CLASS), CLASS_KEYWORD, 66));
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
        }
        for (IField iField : result) {
            reporter.reportField(iField, this.getSuffix(), replaceRange, concreteContext.getTriggerType() == IClassMemberContext.Trigger.OBJECT);
        }
    }

    private boolean isStaticCall(String type) {
        return "PHP_LABEL".equals(type) || "PHP_PARENT".equals(type) || "PHP_SELF".equals(type) || "PHP_NS_SEPARATOR".equals(type) || "PHP_STATIC".equals(type);
    }

    @Override
    protected boolean showNonStaticMembers(IClassMemberContext context) {
        return super.showNonStaticMembers(context) && !this.isParentCall(context);
    }

    public String getSuffix() {
        return "";
    }
}

