/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class Attribute
extends Statement {
    private Identifier name;
    protected ASTNode.NodeList<Expression> parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(Attribute.class, "name", Identifier.class, true, false);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(Attribute.class, "parameters", Expression.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(PARAMETERS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public Attribute(int start, int end, AST ast, Identifier name, List<Expression> parameters) {
        super(start, end, ast);
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setAttributeName(name);
        if (parameters != null) {
            this.parameters.addAll(parameters);
        }
    }

    public Attribute(AST ast) {
        super(ast);
    }

    public List<Expression> parameters() {
        return this.parameters;
    }

    public Identifier getAttributeName() {
        return this.name;
    }

    public void setAttributeName(Identifier id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Identifier oldChild = this.name;
        this.preReplaceChild(oldChild, id, NAME_PROPERTY);
        this.name = id;
        this.postReplaceChild(oldChild, id, NAME_PROPERTY);
    }

    @Override
    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getAttributeName();
            }
            this.setAttributeName((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        return super.internalGetChildListProperty(property);
    }

    public final IMethodBinding resolveAttributeBidining() {
        return this.ast.getBindingResolver().resolveAttribute(this);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.name.accept(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.name.traverseTopDown(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.name.traverseBottomUp(visitor);
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<Attribute");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.name.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append("\t").append(tab).append("<Parameters>\n");
        for (ASTNode aSTNode : this.parameters) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</Parameters>\n");
        buffer.append(tab).append("</Attribute>");
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    public int getType() {
        return 82;
    }

    @Override
    ASTNode clone0(AST target) {
        Identifier name = ASTNode.copySubtree(target, this.getAttributeName());
        List<Expression> arguments = ASTNode.copySubtrees(target, this.parameters());
        return new Attribute(this.getStart(), this.getEnd(), target, name, arguments);
    }
}

