/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.modisco.infra.common.core.internal.Messages;
import org.eclipse.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.modisco.infra.common.core.internal.builder.OpenResourceException;
import org.eclipse.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;

public class EcoreCatalog
extends AbstractMoDiscoCatalog {
    private static final String DEBUG_ID = "org.eclipse.modisco.infra.common.core/debug/EcoreCatalog/debug";
    static final boolean DEBUG = CommonModiscoActivator.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.modisco.infra.common.core/debug/EcoreCatalog/debug"));
    public static final String NS_URI_CONFLICT_MARKER = String.valueOf(CommonModiscoActivator.getDefault().getBundle().getSymbolicName()) + ".nsuriconflict";
    private static EcoreCatalog singleton;
    private static Map<EPackage, IFile> ePackageToFileMap;
    private Map<URI, IFile> nsuriToFile;
    private static Map<String, Object> originalRegistry;

    static {
        ePackageToFileMap = new HashMap<EPackage, IFile>();
        originalRegistry = null;
        originalRegistry = new HashMap<String, Object>();
        Set entrySet = EPackage.Registry.INSTANCE.entrySet();
        for (Map.Entry entry : entrySet) {
            originalRegistry.put((String)entry.getKey(), entry.getValue());
        }
    }

    public static synchronized EcoreCatalog getSingleton() {
        if (singleton == null) {
            singleton = new EcoreCatalog();
        }
        return singleton;
    }

    protected EcoreCatalog() {
    }

    @Override
    protected String getMoDiscoSubProtocol() {
        return null;
    }

    @Override
    protected String getRegistryExtensionPoint() {
        return null;
    }

    @Override
    protected Class<?> getRootClass() {
        return EPackage.class;
    }

    @Override
    protected String getRootObjectName(EObject rootObject) {
        return ((EPackage)rootObject).getName();
    }

    @Override
    protected String getRootObjectNsUri(EObject rootObject) {
        return ((EPackage)rootObject).getNsURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void postOpenResource(URI uri, IFile file, EObject root) throws Exception {
        MoDiscoResourceSet e2;
        EPackage ePackage = (EPackage)root;
        for (URI oldURI : this.getNsUriToFile().keySet()) {
            IFile oldFile = this.getNsUriToFile().get(oldURI);
            if (oldFile == null || !oldFile.equals((Object)file)) continue;
            this.getEPackageRegistry().remove((Object)oldURI.toString());
            this.restoreRegistryEntry(oldURI.toString());
        }
        ePackageToFileMap.put(ePackage, file);
        URI nsUri = URI.createURI((String)this.getRootObjectNsUri((EObject)ePackage));
        IFile oldFile = this.getNsUriToFile().get(nsUri);
        if (oldFile != null && file != null && !oldFile.getFullPath().equals((Object)file.getFullPath())) {
            IMarker marker = file.createMarker(NS_URI_CONFLICT_MARKER);
            marker.setAttribute("message", (Object)(String.valueOf(Messages.EcoreCatalog_uriConflict) + oldFile.getFullPath()));
            marker.setAttribute("severity", 2);
            throw new OpenResourceException();
        }
        Resource mmResource = null;
        try {
            MoDiscoResourceSet moDiscoResourceSet = MoDiscoResourceSet.getResourceSetSingleton();
            synchronized (moDiscoResourceSet) {
                mmResource = MoDiscoResourceSet.getResourceSetSingleton().getResource(nsUri, false);
            }
        }
        catch (Exception e2) {
            Status status = new Status(2, "org.eclipse.modisco.infra.common.core", e2.getMessage(), (Throwable)e2);
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
        if (mmResource == null) {
            e2 = MoDiscoResourceSet.getResourceSetSingleton();
            synchronized (e2) {
                mmResource = MoDiscoResourceSet.getResourceSetSingleton().createResource(nsUri);
            }
        }
        e2 = mmResource;
        synchronized (e2) {
            mmResource.getContents().clear();
            mmResource.getContents().add((Object)ePackage);
        }
        String rootObjectNsUri = this.getRootObjectNsUri((EObject)ePackage);
        this.getEPackageRegistry().put((Object)rootObjectNsUri, (Object)ePackage);
        if (DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".postOpenResource(): " + nsUri);
        }
        this.getNsUriToFile().put(nsUri, file);
    }

    private synchronized Map<URI, IFile> getNsUriToFile() {
        if (this.nsuriToFile == null) {
            this.nsuriToFile = new HashMap<URI, IFile>();
        }
        return this.nsuriToFile;
    }

    @Override
    protected synchronized void preRemove(IFile declarationFile, String pathName, EObject oldRootObject) {
        if (oldRootObject != null) {
            EPackage ePackage = (EPackage)oldRootObject;
            if (DEBUG) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".preRemove(): " + ePackage.getNsURI());
            }
            URI uri = URI.createURI((String)ePackage.getNsURI());
            this.getNsUriToFile().remove(uri);
            ePackageToFileMap.remove(ePackage);
            this.getEPackageRegistry().remove((Object)uri.toString());
            this.restoreRegistryEntry(uri.toString());
        } else if (DEBUG) {
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ".preRemove(): oldRootObject is null.");
        }
    }

    public String getOriginalLocation(EPackage ePackage) {
        IFile file = ePackageToFileMap.get(ePackage);
        if (file == null) {
            return "";
        }
        return file.getFullPath().toString();
    }

    @Override
    protected Plugin getActivator() {
        return CommonModiscoActivator.getDefault();
    }

    @Override
    public String getFileExtension() {
        return "ecore";
    }

    private EPackage.Registry getEPackageRegistry() {
        return EPackage.Registry.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRegistryEntry(String nsURI) {
        Object value;
        if (originalRegistry != null && (value = originalRegistry.get(nsURI)) != null) {
            if (value instanceof EPackage) {
                Resource resource;
                EPackage ePackage = (EPackage)value;
                Resource resource2 = resource = new EcoreResourceFactoryImpl().createResource(URI.createURI((String)nsURI));
                synchronized (resource2) {
                    resource.getContents().add((Object)ePackage);
                }
                EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)ePackage);
            } else {
                EPackage.Registry.INSTANCE.put((Object)nsURI, value);
            }
        }
    }
}

