/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.ArrayDescription;
import org.eclipse.mat.hprof.ChunkedGZIPRandomAccessFile;
import org.eclipse.mat.hprof.CompressedRandomAccessFile;
import org.eclipse.mat.hprof.DefaultPositionInputStream;
import org.eclipse.mat.hprof.FileCacheCompressedRandomAccessFile;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.describer.Version;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.io.BufferedRandomAccessInputStream;
import org.eclipse.mat.parser.model.AbstractObjectImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.MessageUtil;

public class HprofRandomAccessParser
extends AbstractParser {
    public static final int LAZY_LOADING_LIMIT = 256;
    private final IPositionInputStream in;

    public HprofRandomAccessParser(File file, String prefix, Version version, int identifierSize, long len, HprofPreferences.HprofStrictness strictnessPreference) throws IOException {
        super(strictnessPreference);
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        boolean gzip = CompressedRandomAccessFile.isGZIP(raf);
        if (gzip) {
            long maxFree;
            long requested;
            ChunkedGZIPRandomAccessFile cgraf = ChunkedGZIPRandomAccessFile.get(raf, file, prefix);
            raf.close();
            raf = cgraf != null ? cgraf : ((requested = len / 10L) > (maxFree = CompressedRandomAccessFile.checkMemSpace(requested)) && FileCacheCompressedRandomAccessFile.isDiskSpace(file, len) ? new FileCacheCompressedRandomAccessFile(file) : new CompressedRandomAccessFile(file, true, len));
        }
        this.in = new DefaultPositionInputStream((InputStream)new BufferedRandomAccessInputStream(raf, 512));
        this.version = version;
        this.idSize = identifierSize;
    }

    public synchronized void close() throws IOException {
        this.in.close();
    }

    public synchronized IObject read(int objectId, long position, ISnapshot dump, IIndexReader.IOne2LongIndex o2hprof) throws IOException, SnapshotException {
        this.in.seek(position);
        int segmentType = this.in.readUnsignedByte();
        if (objectId == -1) {
            segmentType = this.skipRecords(segmentType);
        }
        switch (segmentType) {
            case 4: {
                return this.readStackFrame(objectId, dump);
            }
            case 33: {
                return this.readInstanceDump(objectId, dump);
            }
            case 34: {
                return this.readObjectArrayDump(objectId, dump);
            }
            case 35: {
                return this.readPrimitiveArrayDump(objectId, dump);
            }
        }
        throw new IOException(MessageUtil.format((String)Messages.HprofRandomAccessParser_Error_IllegalDumpSegment, (Object[])new Object[]{segmentType, Long.toHexString(position)}));
    }

    private IObject readStackFrame(int objectId, ISnapshot dump) throws SnapshotException, IOException {
        int[] thrds;
        this.in.readUnsignedInt();
        this.in.readUnsignedInt();
        long frameId = this.in.readID(this.idSize);
        this.in.readID(this.idSize);
        this.in.readID(this.idSize);
        this.in.readID(this.idSize);
        this.in.readUnsignedInt();
        int lineNr = this.in.readInt();
        IClass classImpl = dump.getClassOf(objectId);
        ArrayList<Field> fields = new ArrayList<Field>();
        Field f = new Field("lineNumber", 10, (Object)lineNr);
        fields.add(f);
        int compLevel = lineNr == -2 ? 1 : 0;
        f = new Field("compilationLevel", 10, (Object)compLevel);
        fields.add(f);
        boolean nativ = lineNr == -3;
        f = new Field("native", 4, (Object)nativ);
        fields.add(f);
        f = new Field("locationAddress", 11, (Object)frameId);
        fields.add(f);
        int[] nArray = thrds = dump.getInboundRefererIds(objectId);
        int n = thrds.length;
        int n2 = 0;
        block0: while (n2 < n) {
            int thrd = nArray[n2];
            IThreadStack stack = dump.getThreadStack(thrd);
            if (stack != null) {
                int fm = 0;
                while (fm < stack.getStackFrames().length) {
                    IStackFrame frm = stack.getStackFrames()[fm];
                    int[] nArray2 = frm.getLocalObjectsIds();
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int oo = nArray2[n4];
                        if (oo == objectId) {
                            f = new Field("frameNumber", 10, (Object)fm);
                            fields.add(f);
                            f = new Field("stackDepth", 10, (Object)(stack.getStackFrames().length - fm));
                            fields.add(f);
                            IClass cls = classImpl;
                            while (cls != null) {
                                for (FieldDescriptor fd : cls.getFieldDescriptors()) {
                                    String stkLine;
                                    if (fd.getName().equals("methodName")) {
                                        stkLine = frm.getText().replaceFirst("\\s*at\\s+([^ ]+).*", "$1");
                                        f = new Field("methodName", 2, (Object)stkLine);
                                        fields.add(f);
                                        continue;
                                    }
                                    if (!fd.getName().equals("fileName")) continue;
                                    stkLine = frm.getText().replaceFirst("\\s*at\\s+[^ ]+\\s+\\(([^:()]*).*", "$1");
                                    if (stkLine.isEmpty()) {
                                        stkLine = null;
                                    }
                                    f = new Field("fileName", 2, (Object)stkLine);
                                    fields.add(f);
                                }
                                cls = cls.getSuperClass();
                            }
                            break block0;
                        }
                        ++n4;
                    }
                    ++fm;
                }
            }
            ++n2;
        }
        long objectAddress = dump.mapIdToAddress(objectId);
        return new InstanceImpl(objectId, objectAddress, (ClassImpl)classImpl, fields);
    }

    public List<IClass> resolveClassHierarchy(ISnapshot snapshot, IClass clazz) throws SnapshotException {
        ArrayList<IClass> answer = new ArrayList<IClass>();
        answer.add(clazz);
        while (clazz.hasSuperClass()) {
            if ((clazz = (IClass)snapshot.getObject(clazz.getSuperClassId())) == null) {
                return null;
            }
            answer.add(clazz);
        }
        return answer;
    }

    private IObject readInstanceDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        IClass oclazz;
        long address;
        block12: {
            address = this.in.readID(this.idSize);
            if (objectId >= 0) {
                if (this.checkSkipBytes(8 + this.idSize) != 8 + this.idSize) {
                    throw new IOException();
                }
                oclazz = dump.getClassOf(objectId);
            } else {
                if (this.checkSkipBytes(4) != 4) {
                    throw new IOException();
                }
                long classAddr = this.in.readID(this.idSize);
                long len = this.in.readUnsignedInt();
                try {
                    int classID = dump.mapAddressToId(classAddr);
                    IObject io = dump.getObject(classID);
                    if (io instanceof IClass) {
                        oclazz = (IClass)io;
                        break block12;
                    }
                    throw new IOException();
                }
                catch (SnapshotException e) {
                    if (this.checkSkipBytes(len) != len) {
                        throw new IOException();
                    }
                    return new InstanceImpl(objectId, address, null, null);
                }
            }
        }
        List<IClass> hierarchy = this.resolveClassHierarchy(dump, oclazz);
        if (hierarchy == null) {
            throw new IOException(Messages.HprofRandomAccessParser_Error_DumpIncomplete);
        }
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (IClass clazz : hierarchy) {
            List fields = clazz.getFieldDescriptors();
            int ii = 0;
            while (ii < fields.size()) {
                FieldDescriptor field = (FieldDescriptor)fields.get(ii);
                int type = field.getType();
                Object value = this.readValue(this.in, dump, type);
                instanceFields.add(new Field(field.getName(), field.getType(), value));
                ++ii;
            }
        }
        ClassImpl classImpl = (ClassImpl)hierarchy.get(0);
        if (dump.isClassLoader(objectId)) {
            return new ClassLoaderImpl(objectId, address, classImpl, instanceFields);
        }
        return new InstanceImpl(objectId, address, classImpl, instanceFields);
    }

    private IArray readObjectArrayDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        int typeId;
        long id = this.in.readID(this.idSize);
        this.checkSkipBytes(4);
        int size = this.in.readInt();
        long len = (long)size * (long)this.idSize;
        long arrayClassObjectID = this.in.readID(this.idSize);
        if (objectId == -1) {
            try {
                typeId = dump.mapAddressToId(arrayClassObjectID);
            }
            catch (SnapshotException e) {
                ObjectArrayImpl array = new ObjectArrayImpl(objectId, id, null, size);
                if (this.checkSkipBytes(len) != len) {
                    throw new IOException();
                }
                return array;
            }
        } else {
            typeId = dump.mapAddressToId(arrayClassObjectID);
        }
        IClass arrayType = (IClass)dump.getObject(typeId);
        if (arrayType == null) {
            throw new RuntimeException(Messages.HprofRandomAccessParser_Error_MissingFakeClass);
        }
        Object content = null;
        if (len < 256L) {
            long[] data = new long[size];
            int ii = 0;
            while (ii < data.length) {
                data[ii] = this.in.readID(this.idSize);
                ++ii;
            }
            content = data;
        } else {
            content = new ArrayDescription.Offline(false, this.in.position(), 0, size);
            if (objectId == -1 && this.checkSkipBytes(len) != len) {
                throw new IOException();
            }
        }
        ObjectArrayImpl array = new ObjectArrayImpl(objectId, id, (ClassImpl)arrayType, size);
        array.setInfo(content);
        return array;
    }

    private IArray readPrimitiveArrayDump(int objectId, ISnapshot dump) throws IOException, SnapshotException {
        long id = this.in.readID(this.idSize);
        this.checkSkipBytes(4);
        int arraySize = this.in.readInt();
        long elementType = this.in.readByte();
        if (elementType < 4L || elementType > 11L) {
            throw new IOException(Messages.Pass1Parser_Error_IllegalType);
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[(int)elementType];
        long len = (long)elementSize * (long)arraySize;
        Object content = null;
        if (len < 256L) {
            Object object;
            byte[] data = new byte[(int)len];
            this.in.readFully(data);
            if (elementType == 8L) {
                object = data;
            } else {
                ArrayDescription.Raw raw;
                object = raw;
                raw = new ArrayDescription.Raw(data);
            }
            content = object;
        } else {
            content = new ArrayDescription.Offline(true, this.in.position(), elementSize, arraySize);
            if (objectId == -1 && this.checkSkipBytes(len) != len) {
                throw new IOException();
            }
        }
        IClass clazz = null;
        String name = IPrimitiveArray.TYPE[(int)elementType];
        Collection classes = dump.getClassesByName(name, false);
        if (classes == null || classes.isEmpty()) {
            if (objectId == -1) {
                PrimitiveArrayImpl array = new PrimitiveArrayImpl(objectId, id, (ClassImpl)clazz, arraySize, (int)elementType);
                return array;
            }
            throw new IOException(MessageUtil.format((String)Messages.HprofRandomAccessParser_Error_MissingClass, (Object[])new Object[]{name}));
        }
        if (classes.size() > 1) {
            throw new IOException(MessageUtil.format((String)Messages.HprofRandomAccessParser_Error_DuplicateClass, (Object[])new Object[]{name}));
        }
        clazz = (IClass)classes.iterator().next();
        PrimitiveArrayImpl array = new PrimitiveArrayImpl(objectId, id, (ClassImpl)clazz, arraySize, (int)elementType);
        array.setInfo(content);
        return array;
    }

    public synchronized long[] readObjectArray(ArrayDescription.Offline descriptor, int offset, int length) throws IOException {
        int elementSize = this.idSize;
        this.in.seek(descriptor.getPosition() + (long)offset * (long)elementSize);
        long[] data = new long[length];
        int ii = 0;
        while (ii < data.length) {
            data[ii] = this.in.readID(this.idSize);
            ++ii;
        }
        return data;
    }

    public synchronized byte[] readPrimitiveArray(ArrayDescription.Offline descriptor, int offset, int length) throws IOException {
        int elementSize = descriptor.getElementSize();
        this.in.seek(descriptor.getPosition() + (long)offset * (long)elementSize);
        byte[] data = new byte[length * elementSize];
        this.in.readFully(data);
        return data;
    }

    private int skipRecords(int segmentType) throws IOException {
        boolean again = true;
        do {
            int skip = -1;
            switch (segmentType) {
                case 28: {
                    skip = 8;
                    break;
                }
                case 5: 
                case 7: 
                case 255: {
                    skip = this.idSize;
                    break;
                }
                case 1: {
                    skip = this.idSize * 2;
                    break;
                }
                case 2: 
                case 3: 
                case 8: {
                    skip = this.idSize + 8;
                    break;
                }
                case 4: 
                case 6: {
                    skip = this.idSize + 4;
                    break;
                }
                case 32: {
                    this.skipClassDump();
                    skip = 0;
                    break;
                }
                default: {
                    again = false;
                }
            }
            if (skip < 0) continue;
            this.checkSkipBytes(skip);
            segmentType = this.in.readUnsignedByte();
        } while (again);
        return segmentType;
    }

    private void skipClassDump() throws IOException {
        this.checkSkipBytes(7 * this.idSize + 8);
        int constantPoolSize = this.in.readUnsignedShort();
        int ii = 0;
        while (ii < constantPoolSize) {
            this.checkSkipBytes(2);
            this.skipValue(this.in);
            ++ii;
        }
        int numStaticFields = this.in.readUnsignedShort();
        int i = 0;
        while (i < numStaticFields) {
            this.checkSkipBytes(this.idSize);
            this.skipValue(this.in);
            ++i;
        }
        int numInstanceFields = this.in.readUnsignedShort();
        this.checkSkipBytes((this.idSize + 1) * numInstanceFields);
    }

    private int checkSkipBytes(int skip) throws IOException {
        int left = skip;
        while (left > 0) {
            int skipped = this.in.skipBytes(left);
            if (skipped == 0) {
                this.in.readByte();
                skipped = 1;
            }
            left -= skipped;
        }
        return skip - left;
    }

    private long checkSkipBytes(long skip) throws IOException {
        long left = skip;
        while (left > 0L) {
            int skipped = this.in.skipBytes(Math.min(left, Integer.MAX_VALUE));
            if (skipped == 0) {
                this.in.readByte();
                skipped = 1;
            }
            left -= (long)skipped;
        }
        return skip - left;
    }

    static /* synthetic */ IPositionInputStream access$0(HprofRandomAccessParser hprofRandomAccessParser) {
        return hprofRandomAccessParser.in;
    }

    static class ObjectAddressReference
    extends ObjectReference {
        private static final long serialVersionUID = 1L;
        transient IIndexReader.IOne2LongIndex o2hprof;
        transient ISnapshot snapshot;
        transient HprofRandomAccessParser parser;

        public ObjectAddressReference(ISnapshot snapshot, HprofRandomAccessParser parser, IIndexReader.IOne2LongIndex o2hprof, long address) {
            super(snapshot, address);
            this.snapshot = snapshot;
            this.o2hprof = o2hprof;
            this.parser = parser;
        }

        public int getObjectId() throws SnapshotException {
            try {
                int id = super.getObjectId();
                return id;
            }
            catch (SnapshotException e) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public IObject getObject() throws SnapshotException {
            block18: {
                e1 = null;
                try {
                    id = super.getObjectId();
                    if (id >= 0) {
                        o = super.getObject();
                        return o;
                    }
                }
                catch (SnapshotException e) {
                    e1 = e;
                }
                low = 0;
                high = this.o2hprof.size() - 1;
                while (low + 1 < high) {
                    mid = low + high >>> 1;
                    midAddr = this.snapshot.mapIdToAddress(mid);
                    if (this.getObjectAddress() < midAddr) {
                        high = mid;
                        continue;
                    }
                    if (this.getObjectAddress() > midAddr) {
                        low = mid;
                        continue;
                    }
                    low = mid;
                    high = mid;
                }
                pos = 0L;
                while ((pos = this.o2hprof.get(low)) == 0L && low > 0) {
                    --low;
                }
                if (pos != 0L) break block18;
                lpos = (Long)this.snapshot.getSnapshotInfo().getProperty("hprof.heap.start");
                if (lpos == null) ** GOTO lbl34
                pos = lpos;
                break block18;
lbl-1000:
                // 1 sources

                {
                    ++low;
lbl34:
                    // 2 sources

                    ** while ((pos = this.o2hprof.get((int)low)) == 0L && low < this.o2hprof.size() - 1)
                }
            }
            posHigh = pos;
            while (high >= 0 && (posHigh = this.o2hprof.get(high)) == 0L && high < this.o2hprof.size() - 1) {
                ++high;
            }
            if (posHigh == 0L) {
                olen = (Long)this.snapshot.getSnapshotInfo().getProperty("hprof.length");
                posHigh = olen != null ? olen : 0x7FFFFFFFFFFFFFFFL;
            }
            try {
                do {
                    var9_13 = this.parser;
                    synchronized (var9_13) {
                        o = this.parser.read(-1, pos, this.snapshot, this.o2hprof);
                        pos = HprofRandomAccessParser.access$0(this.parser).position();
                    }
                    if (o.getObjectAddress() != this.getObjectAddress()) continue;
                    if (o.getClazz() == null) {
                        throw new IOException();
                    }
                    ((AbstractObjectImpl)o).setSnapshot(this.snapshot);
                    return o;
                } while (o.getObjectAddress() <= this.getObjectAddress() && pos < posHigh);
            }
            catch (IOException e2) {
                if (e2 instanceof EOFException) {
                    throw e1;
                }
                throw new SnapshotException((Throwable)e2);
            }
            throw e1;
        }
    }
}

