/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;

public class JEJarEntryResource
extends JEAttribute {
    private final JEAttribute fParent;
    private final String fName;
    private IJarEntryResource fJarEntryResource;

    JEJarEntryResource(JEAttribute parent, String name, IJarEntryResource jarEntryResource) {
        Assert.isNotNull((Object)jarEntryResource);
        this.fParent = parent;
        this.fName = name;
        this.fJarEntryResource = jarEntryResource;
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JEJarEntryResource other = (JEJarEntryResource)obj;
        if (!Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        return Objects.equals(this.fName, other.fName);
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0) + this.fJarEntryResource.hashCode();
    }

    @Override
    public Object getWrappedObject() {
        return this.fJarEntryResource;
    }

    public IJarEntryResource getJarEntryResource() {
        return this.fJarEntryResource;
    }

    @Override
    public JEAttribute[] getChildren() {
        ArrayList<JEAttribute> result = new ArrayList<JEAttribute>();
        Object parent = this.fJarEntryResource.getParent();
        if (parent instanceof IJarEntryResource) {
            result.add(new JEJarEntryResource(this, "PARENT", (IJarEntryResource)parent));
        } else {
            result.add(new JavaElement(this, "PARENT", (IJavaElement)parent));
        }
        result.add(new JavaElement(this, "PACKAGE FRAGMENT ROOT", (IJavaElement)this.fJarEntryResource.getPackageFragmentRoot()));
        result.add(new JavaElementChildrenProperty(this, "CHILDREN"){

            @Override
            protected JEAttribute[] computeChildren() throws CoreException {
                IJarEntryResource[] jarEntryResources = JEJarEntryResource.this.getJarEntryResource().getChildren();
                JEAttribute[] children = new JEAttribute[jarEntryResources.length];
                int i = 0;
                while (i < jarEntryResources.length) {
                    children[i] = new JEJarEntryResource(this, null, jarEntryResources[i]);
                    ++i;
                }
                return children;
            }
        });
        return result.toArray(new JEAttribute[result.size()]);
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.fName != null) {
            sb.append(this.fName).append(": ");
        }
        String classname = this.fJarEntryResource.getClass().getName();
        sb.append(classname.substring(classname.lastIndexOf(46) + 1)).append(": ");
        sb.append(this.fJarEntryResource.getName());
        return sb.toString();
    }
}

