/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalOwnerShapeEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.AndGateFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.AndGateTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.LogicColorConstants;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.OrGateFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.OrGateTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.OutputTerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.TerminalFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.XOrGateFigure;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.AndGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.InputTerminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class LogicGateEditPart
extends TerminalOwnerShapeEditPart {
    public LogicGateEditPart(View view) {
        super(view);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new NonResizableEditPolicyEx();
    }

    protected NodeFigure createMainFigure() {
        if (this.getModel() == null) {
            return null;
        }
        View view = (View)this.getModel();
        EObject semanticElement = view.getElement();
        EClass eClazz = semanticElement.eClass();
        Dimension gateSize = new Dimension(this.getMapMode().DPtoLP(15), this.getMapMode().DPtoLP(17));
        NodeFigure newFigure = eClazz == SemanticPackage.eINSTANCE.getOrGate() ? new OrGateFigure(gateSize) : (eClazz == SemanticPackage.eINSTANCE.getAndGate() ? new AndGateFigure(gateSize) : (eClazz == SemanticPackage.eINSTANCE.getXORGate() ? new XOrGateFigure(gateSize) : null));
        return newFigure;
    }

    protected void refreshBounds() {
        Dimension size = this.getFigure().getSize();
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    @Override
    public Map createBoundsMap() {
        HashMap<String, Point> boundMap = new HashMap<String, Point>();
        if (this.getModel() == null || !(this.getModel() instanceof View)) {
            return boundMap;
        }
        View view = (View)this.getModel();
        EObject semanticElement = view.getElement();
        EClass eClazz = semanticElement.eClass();
        IMapMode mm = this.getMapMode();
        if (eClazz == SemanticPackage.eINSTANCE.getOrGate()) {
            boundMap.put("A", new Point(mm.DPtoLP(4), mm.DPtoLP(3)));
            boundMap.put("B", new Point(mm.DPtoLP(5), mm.DPtoLP(3)));
            boundMap.put("1", new Point(mm.DPtoLP(5), mm.DPtoLP(9)));
        } else if (eClazz == SemanticPackage.eINSTANCE.getAndGate()) {
            boundMap.put("A", new Point(mm.DPtoLP(4), mm.DPtoLP(3)));
            boundMap.put("B", new Point(mm.DPtoLP(9), mm.DPtoLP(3)));
            boundMap.put("1", new Point(mm.DPtoLP(6), mm.DPtoLP(9)));
        } else {
            boundMap.put("A", new Point(mm.DPtoLP(4), mm.DPtoLP(3)));
            boundMap.put("B", new Point(mm.DPtoLP(5), mm.DPtoLP(3)));
            boundMap.put("1", new Point(mm.DPtoLP(5), mm.DPtoLP(9)));
        }
        return boundMap;
    }

    @Override
    public NodeFigure createOwnedTerminalFigure(TerminalEditPart terminalEP) {
        Terminal terminal = (Terminal)ViewUtil.resolveSemanticElement((View)((View)terminalEP.getModel()));
        if (terminal == null) {
            return null;
        }
        TerminalFigure theFigure = null;
        if (terminal instanceof InputTerminal) {
            theFigure = terminal.eContainer() instanceof AndGate ? new AndGateTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(4), this.getMapMode().DPtoLP(2))) : new OrGateTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(4), this.getMapMode().DPtoLP(4)));
            terminalEP.setLocator(new GateTerminalLocator(this.getFigure(), true));
        } else {
            theFigure = new OutputTerminalFigure(terminal.getId(), new Dimension(this.getMapMode().DPtoLP(4), this.getMapMode().DPtoLP(5)));
            terminalEP.setLocator(new GateTerminalLocator(this.getFigure(), false));
        }
        return theFigure;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            View view = (View)this.getModel();
            EObject semanticElement = view.getElement();
            EClass eClazz = semanticElement.eClass();
            if (eClazz == SemanticPackage.eINSTANCE.getOrGate()) {
                return FigureUtilities.colorToInteger((Color)LogicColorConstants.andGate);
            }
            if (eClazz == SemanticPackage.eINSTANCE.getAndGate()) {
                return FigureUtilities.colorToInteger((Color)LogicColorConstants.orGate);
            }
            if (eClazz == SemanticPackage.eINSTANCE.getXORGate()) {
                return FigureUtilities.colorToInteger((Color)LogicColorConstants.xorGate);
            }
        } else if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
            return FigureUtilities.colorToInteger((Color)LogicColorConstants.logicBlack);
        }
        return super.getPreferredValue(feature);
    }

    private class GateTerminalLocator
    extends BorderItemLocator {
        public GateTerminalLocator(IFigure parentFigure, boolean isInputTerminal) {
            super(parentFigure);
            if (isInputTerminal) {
                this.setPreferredSideOfParent(1);
            } else {
                this.setPreferredSideOfParent(4);
            }
        }

        public void relocate(IFigure borderItem) {
            Rectangle bounds = this.getParentFigure().getBounds();
            Point pos = new Point();
            if (this.getPreferredSideOfParent() == 1) {
                int gap = (bounds.width - 2 * borderItem.getBounds().width) / 3;
                pos.x = bounds.x + gap;
                pos.y = bounds.y;
                if (this.conflicts(pos, borderItem)) {
                    pos.x += borderItem.getBounds().width + gap - 25;
                }
            } else if (this.getPreferredSideOfParent() == 4) {
                pos.x = bounds.x + (bounds.width - borderItem.getBounds().width) / 2;
                pos.y = bounds.y + bounds.height;
            }
            borderItem.setBounds(new Rectangle(pos, borderItem.getSize()));
        }

        private boolean conflicts(Point recommendedLocation, IFigure targetBorderItem) {
            Rectangle recommendedRect = new Rectangle(recommendedLocation, targetBorderItem.getSize());
            List borderItems = targetBorderItem.getParent().getChildren();
            ListIterator iterator = borderItems.listIterator();
            while (iterator.hasNext()) {
                IFigure borderItem = (IFigure)iterator.next();
                if (!borderItem.isVisible()) continue;
                Rectangle rect = borderItem.getBounds().getCopy();
                if (borderItem == targetBorderItem || !rect.intersects(recommendedRect) || rect.getLocation().equals((Object)targetBorderItem.getParent().getBounds().getLocation())) continue;
                return true;
            }
            return false;
        }
    }
}

