/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IMergePreviewModeChange;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DropDownMergeMenuAction
extends Action
implements IMenuCreator {
    private final IEMFCompareConfiguration configuration;
    private Menu fMenu;
    private final List<DropDownAction> actions;

    public DropDownMergeMenuAction(IEMFCompareConfiguration configuration, EnumSet<MergeMode> previewModes) {
        this.configuration = configuration;
        this.actions = Lists.newArrayList();
        MergeMode currentPreviewMode = configuration.getMergePreviewMode();
        for (MergeMode mergePreviewMode : previewModes) {
            DropDownAction action = new DropDownAction(configuration, mergePreviewMode);
            this.actions.add(action);
            if (mergePreviewMode != currentPreviewMode) continue;
            action.setChecked(true);
        }
        DropDownAction action = new DropDownAction(configuration, null);
        this.actions.add(action);
        if (currentPreviewMode == null) {
            action.setChecked(true);
        }
        DropDownMergeMenuAction.setTextAndImage((IAction)this, currentPreviewMode);
        this.setMenuCreator(this);
        configuration.getEventBus().register((Object)this);
    }

    @Subscribe
    public void mergePreviewModeChange(IMergePreviewModeChange event) {
        MergeMode mergeMode = event.getNewValue();
        for (DropDownAction dropDownAction : this.actions) {
            dropDownAction.setChecked(mergeMode == dropDownAction.getMergeMode());
        }
        DropDownMergeMenuAction.setTextAndImage((IAction)this, mergeMode);
    }

    public void run() {
        MergeMode mergeWay = this.configuration.getMergePreviewMode();
        if (mergeWay == null) {
            this.actions.get(0).run();
        } else {
            this.configuration.setMergePreviewMode(mergeWay.inverse());
        }
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        this.configuration.getEventBus().unregister((Object)this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        for (IAction iAction : this.actions) {
            this.addActionToMenu(this.fMenu, iAction);
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    static void setTextAndImage(IAction action, MergeMode mergeMode) {
        if (mergeMode == null) {
            action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/disabled_highlight_related_changes.gif"));
            action.setToolTipText(EMFCompareIDEUIMessages.getString("dropdown.disabled"));
            action.setText(EMFCompareIDEUIMessages.getString("dropdown.disabled"));
        } else {
            switch (mergeMode) {
                case LEFT_TO_RIGHT: {
                    action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/left_to_right.gif"));
                    action.setToolTipText(EMFCompareIDEUIMessages.getString("dropdown.left.to.right.text"));
                    action.setText(EMFCompareIDEUIMessages.getString("dropdown.left.to.right.text"));
                    break;
                }
                case RIGHT_TO_LEFT: {
                    action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/right_to_left.gif"));
                    action.setToolTipText(EMFCompareIDEUIMessages.getString("dropdown.right.to.left.text"));
                    action.setText(EMFCompareIDEUIMessages.getString("dropdown.right.to.left.text"));
                    break;
                }
                case ACCEPT: {
                    action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept.gif"));
                    action.setToolTipText(EMFCompareIDEUIMessages.getString("dropdown.accept.text"));
                    action.setText(EMFCompareIDEUIMessages.getString("dropdown.accept.text"));
                    break;
                }
                case REJECT: {
                    action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject.gif"));
                    action.setToolTipText(EMFCompareIDEUIMessages.getString("dropdown.reject.text"));
                    action.setText(EMFCompareIDEUIMessages.getString("dropdown.reject.text"));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private static class DropDownAction
    extends Action {
        private final IEMFCompareConfiguration configuration;
        private final MergeMode mergeMode;

        public DropDownAction(IEMFCompareConfiguration configuration, MergeMode mergeMode) {
            super("", 8);
            this.configuration = configuration;
            this.mergeMode = mergeMode;
            DropDownMergeMenuAction.setTextAndImage((IAction)this, mergeMode);
        }

        public MergeMode getMergeMode() {
            return this.mergeMode;
        }

        public void run() {
            this.configuration.setMergePreviewMode(this.mergeMode);
        }
    }
}

