/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wb.core.gef.header.Headers;
import org.eclipse.wb.core.gef.header.IHeaderMenuProvider;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.tools.ParentTargetDragEditPartTracker;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.SetTemplateAction;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionTemplate;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;

public abstract class DimensionHeaderEditPart<T extends FormDimensionInfo>
extends GraphicalEditPart
implements IHeaderMenuProvider {
    protected static final Color COLOR_NORMAL = Headers.COLOR_HEADER;
    protected static final Color COLOR_GAP = DrawUtils.getShiftedColor((Color)COLOR_NORMAL, (int)-32);
    protected static final Font DEFAULT_FONT = new Font(null, "Arial", 7, 0);
    protected static final Color[] GROUP_COLORS = new Color[]{new Color(null, 200, 255, 200), new Color(null, 255, 210, 170), new Color(null, 180, 255, 255), new Color(null, 255, 255, 180), new Color(null, 230, 180, 255)};
    protected final FormLayoutInfo m_layout;
    protected final T m_dimension;
    private final IFigure m_containerFigure;

    public DimensionHeaderEditPart(FormLayoutInfo layout, T dimension, IFigure containerFigure) {
        this.m_layout = layout;
        this.m_dimension = dimension;
        this.m_containerFigure = containerFigure;
        this.setModel(dimension);
    }

    public abstract int getIndex();

    public final FormLayoutInfo getLayout() {
        return this.m_layout;
    }

    public final T getDimension() {
        return this.m_dimension;
    }

    public final Point getOffset() {
        Point offset = new Point(0, 0);
        FigureUtils.translateFigureToAbsolute2((IFigure)this.m_containerFigure, (Translatable)offset);
        return offset;
    }

    public final Tool getDragTracker(Request request) {
        return new ParentTargetDragEditPartTracker((EditPart)this);
    }

    protected void refreshVisuals() {
        String tooltip = ((FormDimensionInfo)this.m_dimension).getToolTip();
        if (tooltip != null && !tooltip.isEmpty()) {
            this.getFigure().setToolTip((IFigure)new Label(tooltip));
        }
        if (((FormDimensionInfo)this.m_dimension).isGap()) {
            this.getFigure().setBackgroundColor(COLOR_GAP);
        } else {
            int group = this.m_layout.getDimensionGroupIndex((FormDimensionInfo)this.m_dimension);
            if (group != -1) {
                this.getFigure().setBackgroundColor(GROUP_COLORS[group % GROUP_COLORS.length]);
            } else {
                this.getFigure().setBackgroundColor(COLOR_NORMAL);
            }
        }
    }

    protected final void addTemplateActions(IMenuManager manager, FormDimensionTemplate[] templates) {
        int i = 0;
        while (i < templates.length) {
            FormDimensionTemplate template = templates[i];
            manager.add(new SetTemplateAction(this, template));
            ++i;
        }
    }

    public void performRequest(Request request) {
        super.performRequest(request);
        if (request.getType() == "open") {
            this.editDimension();
        }
    }

    protected abstract void editDimension();
}

