/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.os;

import java.awt.EventQueue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.os.OSSupportError;
import org.osgi.framework.Bundle;

public abstract class OSSupport {
    private static final OSSupport INSTANCE = OSSupport.getInstance();
    public static final String WBP_DISABLED_REDRAW = "WBP_DISABLED_REDRAW";
    public static final String WBP_NEED_IMAGE = "WBP_NEED_IMAGE";
    public static final String WBP_IMAGE = "WBP_IMAGE";

    public static OSSupport get() {
        return INSTANCE;
    }

    private static OSSupport getInstance() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wb.os", "OSSupport");
            if (configurationElements.length != 0) {
                IConfigurationElement element = iConfigurationElementArray[0];
                IExtension extension = element.getDeclaringExtension();
                String id = extension.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)id);
                String className = element.getAttribute("class");
                Class loadedClass = bundle.loadClass(className);
                Field field = loadedClass.getDeclaredField("INSTANCE");
                field.setAccessible(true);
                return (OSSupport)field.get(null);
            }
            throw new OSSupportError("Can't find the support for current OS.");
        }
        catch (Throwable e) {
            throw new OSSupportError("Can't initialize the support for current OS: ", e);
        }
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public final void makeShots(Object control) throws Exception {
        this.makeShots((Control)control);
    }

    public abstract void makeShots(Control var1) throws Exception;

    @Deprecated(forRemoval=true, since="2025-12")
    public final void beginShot(Object controlObject) {
        this.beginShot((Control)controlObject);
    }

    public void beginShot(Control control) {
        Shell shell = this.layoutShell(control);
        this.makeShellVisible(shell);
    }

    protected void makeShellVisible(Shell shell) {
        shell.setLocation(-10000, -10000);
        shell.setVisible(true);
    }

    @Deprecated(forRemoval=true, since="2025-12")
    protected final Shell layoutShell(Object controlObject) {
        Control control = (Control)controlObject;
        Shell shell = control.getShell();
        OSSupport.doLayout((Control)shell);
        OSSupport.fixZeroSizes_begin((Control)shell);
        return shell;
    }

    protected final Shell layoutShell(Control control) {
        Shell shell = control.getShell();
        OSSupport.doLayout((Control)shell);
        OSSupport.fixZeroSizes_begin((Control)shell);
        return shell;
    }

    private static void doLayout(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                OSSupport.doLayout(child);
                ++n2;
            }
            composite.layout();
        }
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public final void endShot(Object controlObject) {
        this.endShot((Control)controlObject);
    }

    public void endShot(Control control) {
        OSSupport.fixZeroSizes_end(control);
        Shell shell = control.getShell();
        shell.setVisible(false);
    }

    public abstract Image makeShot(Control var1) throws Exception;

    public abstract int getDefaultMenuBarHeight();

    private static void fixZeroSizes_begin(Control control) {
        if (control.getBounds().isEmpty()) {
            control.setData(WBP_DISABLED_REDRAW, (Object)Boolean.TRUE);
            control.setRedraw(false);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                OSSupport.fixZeroSizes_begin(child);
                ++n2;
            }
        }
    }

    private static void fixZeroSizes_end(Control control) {
        if (control.getData(WBP_DISABLED_REDRAW) != null) {
            control.setData(WBP_DISABLED_REDRAW, null);
            control.setRedraw(true);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                OSSupport.fixZeroSizes_end(child);
                ++n2;
            }
        }
    }

    @Deprecated(forRemoval=true, since="2025-12")
    public final Rectangle getTabItemBounds(Object item) {
        return this.getTabItemBounds((TabItem)item);
    }

    public abstract Rectangle getTabItemBounds(TabItem var1);

    public abstract void setAlpha(Shell var1, int var2);

    public abstract int getAlpha(Shell var1);

    public abstract Image getMenuPopupVisualData(Menu var1, int[] var2) throws Exception;

    public abstract Image getMenuBarVisualData(Menu var1, List<Rectangle> var2);

    public abstract Rectangle getMenuBarBounds(Menu var1);

    public abstract boolean isPlusMinusTreeClick(Tree var1, int var2, int var3);

    public int[] getPushButtonInsets() {
        return new int[0];
    }

    public void scroll(Control cursorControl, int count) {
    }

    public Image makeShotAwt(Object component, int width, int height) {
        return null;
    }

    public void runAwt(Runnable job) {
        if (EventQueue.isDispatchThread()) {
            job.run();
        } else {
            try {
                EventQueue.invokeAndWait(job);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Platform.getLog(OSSupport.class).error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

