/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.editor.constants;

import java.net.URI;
import java.net.URL;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class CoreImages {
    private static ResourceManager RESOURCE_MANAGER = new LocalResourceManager(JFaceResources.getResources());
    public static ImageDescriptor ALIGNMENT_H_MENU_CENTER = CoreImages.of("alignment/h/menu/center.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_DEFAULT = CoreImages.of("alignment/h/menu/default.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_DELETE = CoreImages.of("alignment/h/menu/delete.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_FILL = CoreImages.of("alignment/h/menu/fill.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_GROW = CoreImages.of("alignment/h/menu/grow.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_LEADING = CoreImages.of("alignment/h/menu/leading.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_LEFT = CoreImages.of("alignment/h/menu/left.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_RIGHT = CoreImages.of("alignment/h/menu/right.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_TRAILING = CoreImages.of("alignment/h/menu/trailing.svg");
    public static ImageDescriptor ALIGNMENT_H_MENU_UNKNOWN = CoreImages.of("alignment/h/menu/unknown.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_CENTER = CoreImages.of("alignment/h/small/center.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_DEFAULT = CoreImages.of("alignment/h/small/default.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_FILL = CoreImages.of("alignment/h/small/fill.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_GROW = CoreImages.of("alignment/h/small/grow.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_LEADING = CoreImages.of("alignment/h/small/leading.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_LEFT = CoreImages.of("alignment/h/small/left.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_RIGHT = CoreImages.of("alignment/h/small/right.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_TRAILING = CoreImages.of("alignment/h/small/trailing.svg");
    public static ImageDescriptor ALIGNMENT_H_SMALL_UNKNOWN = CoreImages.of("alignment/h/small/unknown.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_BOTTOM = CoreImages.of("alignment/v/menu/bottom.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_CENTER = CoreImages.of("alignment/v/menu/center.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_DEFAULT = CoreImages.of("alignment/v/menu/default.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_DELETE = CoreImages.of("alignment/v/menu/delete.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_FILL = CoreImages.of("alignment/v/menu/fill.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_GROW = CoreImages.of("alignment/v/menu/grow.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_TOP = CoreImages.of("alignment/v/menu/top.svg");
    public static ImageDescriptor ALIGNMENT_V_MENU_UNKNOWN = CoreImages.of("alignment/v/menu/unknown.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_BOTTOM = CoreImages.of("alignment/v/small/bottom.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_CENTER = CoreImages.of("alignment/v/small/center.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_DEFAULT = CoreImages.of("alignment/v/small/default.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_FILL = CoreImages.of("alignment/v/small/fill.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_GROW = CoreImages.of("alignment/v/small/grow.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_TOP = CoreImages.of("alignment/v/small/top.svg");
    public static ImageDescriptor ALIGNMENT_V_SMALL_UNKNOWN = CoreImages.of("alignment/v/small/unknown.svg");
    public static ImageDescriptor PROPERTIES_BOOLEAN_NULL = CoreImages.of("properties/BooleanNull.svg");
    public static ImageDescriptor PROPERTIES_BOOLEAN_UNKNOWN = CoreImages.of("properties/BooleanUnknown.svg");
    public static ImageDescriptor PROPERTIES_DOTS = CoreImages.of("properties/dots.svg");
    public static ImageDescriptor PROPERTIES_DOWN = CoreImages.of("properties/down.svg");
    public static ImageDescriptor PROPERTIES_DT = CoreImages.of("properties/dt.svg");
    public static ImageDescriptor PROPERTIES_FALSE = CoreImages.of("properties/false.svg");
    public static ImageDescriptor PROPERTIES_MINUS = CoreImages.of("properties/minus.svg");
    public static ImageDescriptor PROPERTIES_PLUS = CoreImages.of("properties/plus.svg");
    public static ImageDescriptor PROPERTIES_TRUE = CoreImages.of("properties/true.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_CENTER_DISABLED = CoreImages.of("info/layout/absolute/align_h_center_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_CENTER = CoreImages.of("info/layout/absolute/align_h_center.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_CENTERS_DISABLED = CoreImages.of("info/layout/absolute/align_h_centers_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_CENTERS = CoreImages.of("info/layout/absolute/align_h_centers.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_LEFT_DISABLED = CoreImages.of("info/layout/absolute/align_h_left_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_LEFT = CoreImages.of("info/layout/absolute/align_h_left.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_RIGHT_DISABLED = CoreImages.of("info/layout/absolute/align_h_right_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_RIGHT = CoreImages.of("info/layout/absolute/align_h_right.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_SPACE_DISABLED = CoreImages.of("info/layout/absolute/align_h_space_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_H_SPACE = CoreImages.of("info/layout/absolute/align_h_space.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_HEIGHT_DISABLED = CoreImages.of("info/layout/absolute/align_height_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_HEIGHT = CoreImages.of("info/layout/absolute/align_height.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_BOTTOM_DISABLED = CoreImages.of("info/layout/absolute/align_v_bottom_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_BOTTOM = CoreImages.of("info/layout/absolute/align_v_bottom.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_CENTER_DISABLED = CoreImages.of("info/layout/absolute/align_v_center_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_CENTER = CoreImages.of("info/layout/absolute/align_v_center.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_CENTERS_DISABLED = CoreImages.of("info/layout/absolute/align_v_centers_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_CENTERS = CoreImages.of("info/layout/absolute/align_v_centers.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_SPACE_DISABLED = CoreImages.of("info/layout/absolute/align_v_space_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_SPACE = CoreImages.of("info/layout/absolute/align_v_space.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_TOP_DISABLED = CoreImages.of("info/layout/absolute/align_v_top_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_V_TOP = CoreImages.of("info/layout/absolute/align_v_top.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_WIDTH_DISABLED = CoreImages.of("info/layout/absolute/align_width_disabled.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_ALIGN_WIDTH = CoreImages.of("info/layout/absolute/align_width.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_BRING_FORWARD = CoreImages.of("info/layout/absolute/bring_forward.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_BRING_TO_FRONT = CoreImages.of("info/layout/absolute/bring_to_front.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_SEND_BACKWARD = CoreImages.of("info/layout/absolute/send_backward.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE_SEND_TO_BACK = CoreImages.of("info/layout/absolute/send_to_back.svg");
    public static ImageDescriptor LAYOUT_ABSOLUTE = CoreImages.of("info/layout/absolute/layout.svg");
    public static ImageDescriptor LAYOUT_FIT_TO_SIZE = CoreImages.of("info/layout/fit_to_size.svg");
    public static ImageDescriptor FOLDER_CLOSED = CoreImages.of("folder_closed.svg");
    public static ImageDescriptor FOLDER_OPEN = CoreImages.of("folder_open.svg");
    public static ImageDescriptor FOLDER_PACKAGE = CoreImages.of("folder_package.svg");

    public static Image getSharedImage(ImageDescriptor imageDescriptor) {
        return (Image)RESOURCE_MANAGER.create((DeviceResourceDescriptor)imageDescriptor);
    }

    private static ImageDescriptor of(String fileName) {
        return CoreImages.of(FrameworkUtil.getBundle(CoreImages.class), fileName);
    }

    protected static ImageDescriptor of(Bundle bundle, String fileName) {
        String effectiveFileName = !DesignerPlugin.isSvgSupported() && fileName.endsWith(".svg") ? fileName.replaceFirst("\\.svg$", ".png") : fileName;
        return ExecutionUtils.runObjectLog(() -> {
            URI uri = URI.create("platform:/plugin/" + bundle.getSymbolicName() + "/icons/" + effectiveFileName);
            URL url = uri.toURL();
            return ImageDescriptor.createFromURL((URL)url);
        }, ImageDescriptor.getMissingImageDescriptor());
    }
}

