/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model;

import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.laf.BaselineSupportHelper;
import org.eclipse.wb.internal.core.model.TopBoundsSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;

public abstract class AbstractComponentInfo
extends JavaInfo
implements IAbstractComponentInfo {
    private Rectangle m_bounds;
    private Rectangle m_modelBounds;
    private Dimension m_preferredSize;
    private Insets m_clientAreaInsets = IFigure.NO_INSETS;
    private Image m_image;
    private TopBoundsSupport m_topBoundsSupport;

    public AbstractComponentInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
    }

    public final Rectangle getBounds() {
        return this.m_bounds;
    }

    public final void setBounds(Rectangle bounds) {
        this.m_bounds = bounds;
    }

    public final Rectangle getModelBounds() {
        return this.m_modelBounds;
    }

    public final void setModelBounds(Rectangle bounds) {
        this.m_modelBounds = bounds;
        this.m_bounds = this.m_modelBounds.getCopy();
        if (this.getParent() instanceof AbstractComponentInfo) {
            AbstractComponentInfo parentComponent = (AbstractComponentInfo)this.getParent();
            this.m_bounds.performTranslate(parentComponent.getClientAreaInsets());
        }
    }

    public final Rectangle getAbsoluteBounds() {
        Rectangle bounds = this.getBounds().getCopy();
        AbstractComponentInfo parent = (AbstractComponentInfo)this.getParent();
        while (parent != null) {
            bounds.performTranslate(parent.getBounds().getLocation());
            parent = (AbstractComponentInfo)parent.getParent();
        }
        AbstractComponentInfo rootComponent = (AbstractComponentInfo)this.getRoot();
        bounds.performTranslate(rootComponent.getBounds().getLocation().getNegated());
        return bounds;
    }

    public final Dimension getPreferredSize() {
        if (this.m_preferredSize == null) {
            return this.getLivePreferredSize();
        }
        return this.m_preferredSize;
    }

    public final void setPreferredSize(Dimension preferredSize) {
        this.m_preferredSize = preferredSize;
    }

    public final int getBaseline() {
        Object object = this.getObject();
        if (object == null) {
            return this.getLiveBaseline();
        }
        return BaselineSupportHelper.getBaseline((Object)object);
    }

    public final Insets getClientAreaInsets() {
        return this.m_clientAreaInsets;
    }

    public final void setClientAreaInsets(Insets clientAreaInsets) {
        this.m_clientAreaInsets = clientAreaInsets;
    }

    public boolean isRTL() {
        return false;
    }

    public final Image getImage() {
        if (this.m_image == null && this.getParent() == null) {
            return this.getLiveImage();
        }
        return this.m_image;
    }

    public final void setImage(Image image) {
        this.m_image = image;
    }

    protected Image getLiveImage() {
        return null;
    }

    protected Dimension getLivePreferredSize() {
        Image liveImage = this.getLiveImage();
        if (liveImage != null) {
            return new Dimension(liveImage.getBounds().width, liveImage.getBounds().height);
        }
        return null;
    }

    protected int getLiveBaseline() {
        return -1;
    }

    @Override
    public void delete() throws Exception {
        super.delete();
        this.refresh_dispose();
    }

    @Override
    public void refresh_dispose() throws Exception {
        if (this.m_image != null) {
            this.m_image.dispose();
            this.m_image = null;
        }
        super.refresh_dispose();
    }

    @Override
    protected void refresh_afterCreate() throws Exception {
        super.refresh_afterCreate();
        if (this.isRoot()) {
            this.getTopBoundsSupport().apply();
        }
    }

    public Object getComponentObject() {
        return this.getObject();
    }

    public final TopBoundsSupport getTopBoundsSupport() {
        if (this.m_topBoundsSupport == null) {
            this.m_topBoundsSupport = this.createTopBoundsSupport();
        }
        return this.m_topBoundsSupport;
    }

    protected TopBoundsSupport createTopBoundsSupport() {
        throw new NotImplementedException();
    }
}

