/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.outline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.providers.FilteredTreeContentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineLabelProvider;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class QuickOutlineControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    protected final SiriusDiagramEditor editor;
    private AdapterFactory adapterFactory;
    private FilteredTree filteredTree;
    private TreeViewer treeViewer;

    public QuickOutlineControl(Shell parentShell, int shellStyle, SiriusDiagramEditor editor) {
        super(parentShell, shellStyle, true, true, true, false, true, null, null);
        this.create();
        this.editor = editor;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public final void dispose() {
        this.filteredTree.dispose();
        this.close();
    }

    public boolean hasContents() {
        return true;
    }

    public boolean isFocusControl() {
        return this.getShell() == Display.getCurrent().getActiveShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filteredTree.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void setLocation(Point location) {
        this.getShell().setLocation(location);
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.adapterFactory = null;
        this.filteredTree = null;
        this.treeViewer = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.createTreeViewer(parent);
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected Object getSelectedElement() {
        if (this.treeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof DDiagramElement) {
            IGraphicalEditPart partToSelect = this.getEditPart((DDiagramElement)selectedElement);
            if (partToSelect != null) {
                this.editor.getDiagramGraphicalViewer().select((EditPart)partToSelect);
                this.editor.getDiagramGraphicalViewer().reveal((EditPart)partToSelect);
            }
            this.close();
        }
    }

    protected IGraphicalEditPart getEditPart(DDiagramElement diagramElement) {
        IEditorPart editorPart = EclipseUIUtil.getActiveEditor();
        return this.getEditPart(diagramElement, editorPart);
    }

    protected IGraphicalEditPart getEditPart(DDiagramElement diagramElement, IEditorPart editorPart) {
        Map editPartRegistry;
        Object editPart;
        IGraphicalEditPart result = null;
        View gmfView = this.getGmfView(diagramElement);
        if (gmfView != null && editorPart instanceof DiagramEditor && (editPart = (editPartRegistry = ((DiagramEditor)editorPart).getDiagramGraphicalViewer().getEditPartRegistry()).get(gmfView)) instanceof IGraphicalEditPart) {
            result = (IGraphicalEditPart)editPart;
        }
        return result;
    }

    protected View getGmfView(DDiagramElement diagramElement) {
        Session session = SessionManager.INSTANCE.getSession(diagramElement.getTarget());
        return SiriusGMFHelper.getGmfView(diagramElement, session);
    }

    protected void createTreeViewer(Composite parent) {
        this.filteredTree = new FilteredTree(parent, 772, new PatternFilter(), true);
        this.treeViewer = this.filteredTree.getViewer();
        final Tree tree = this.treeViewer.getTree();
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u001b') {
                    QuickOutlineControl.this.dispose();
                }
                if (event.keyCode == 13) {
                    QuickOutlineControl.this.gotoSelectedElement();
                }
                if (event.keyCode == 0x1000002) {
                    tree.setFocus();
                }
                if (event.keyCode == 0x1000001) {
                    tree.setFocus();
                }
                if (event.character == '\u001b') {
                    QuickOutlineControl.this.dispose();
                }
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlineControl.this.gotoSelectedElement();
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new FilteredTreeContentProvider(this.getAdapterFactory(), (Predicate<Object>)Predicates.or((Predicate)Predicates.instanceOf(DDiagramElement.class), (Predicate)Predicates.instanceOf(AbstractDDiagramElementLabelItemProvider.class))));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DDiagramElement;
            }
        });
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            ArrayList<Object> factories = new ArrayList<Object>();
            factories.add(new ViewpointItemProviderAdapterFactory());
            factories.add((Object)new DiagramItemProviderAdapterFactory());
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new EcoreItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
            this.adapterFactory = new ComposedAdapterFactory(factories);
        }
        return this.adapterFactory;
    }

    protected boolean hasTitleArea() {
        return false;
    }
}

