/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.actions.CodeGenerationSettings;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public final class AddGetterSetterOperation
implements IWorkspaceRunnable {
    private final IField[] fAccessorFields;
    private boolean fApply = true;
    private TextEdit fEdit = null;
    private final IField[] fGetterFields;
    private final IMethod fInsert;
    private final IField[] fSetterFields;
    private final CodeGenerationSettings fSettings;
    private boolean fSkipAllExisting = false;
    private boolean fSort = false;
    private final IType fType;
    private final Program fASTRoot;
    private int fVisibility = 64;
    private IDocument fDocument;

    public AddGetterSetterOperation(IType type, IField[] getters, IField[] setters, IField[] accessors, Program unit, IDocument document, IMethod insert, CodeGenerationSettings settings, boolean apply) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)settings);
        this.fType = type;
        this.fGetterFields = getters;
        this.fSetterFields = setters;
        this.fAccessorFields = accessors;
        this.fASTRoot = unit;
        this.fInsert = insert;
        this.fSettings = settings;
        this.fApply = apply;
        this.fDocument = document;
    }

    private void generateGetterMethod(IField field, ListRewrite rewrite) throws CoreException {
        IType type = field.getDeclaringType();
        String name = CodeGenerationUtils.getGetterName(field);
        IMethod existing = CodeGenerationUtils.findMethod(name, 0, false, type);
        if (existing == null) {
            IMethod sibling = this.fInsert;
            ASTNode insertion = CodeGenerationUtils.getNodeToInsertBefore(rewrite, (IModelElement)sibling);
            String fieldType = CodeGenerationUtils.getFieldDefinitionType(field, this.fASTRoot);
            CodeGenerationUtils.createGetterStub(field, fieldType, name, this.fSettings.createComments, this.fSettings.useType, this.fVisibility | field.getFlags() & 0x80, type, rewrite, insertion);
        }
    }

    private void generateSetterMethod(IField field, ASTRewrite astRewrite, ListRewrite rewrite) throws CoreException {
        IType type = field.getDeclaringType();
        String name = CodeGenerationUtils.getSetterName(field);
        IMethod existing = CodeGenerationUtils.findMethod(name, 1, false, type);
        if (existing == null) {
            IMethod sibling = this.fInsert;
            ASTNode insertion = CodeGenerationUtils.getNodeToInsertBefore(rewrite, (IModelElement)sibling);
            String fieldType = CodeGenerationUtils.getFieldDefinitionType(field, this.fASTRoot);
            CodeGenerationUtils.createSetterStub(field, fieldType, name, this.fSettings.createComments, this.fSettings.useType, this.fSettings.setSelfType, this.fVisibility | field.getFlags() & 0x80, rewrite, insertion);
        }
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final int getVisibility() {
        return this.fVisibility;
    }

    public final boolean isSkipAllExisting() {
        return this.fSkipAllExisting;
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        int n;
        int n2;
        IField[] iFieldArray;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("AddGetterSetterOperation_description");
        monitor.beginTask("", this.fGetterFields.length + this.fSetterFields.length);
        ASTRewrite astRewrite = ASTRewrite.create((AST)this.fASTRoot.getAST());
        ListRewrite listRewriter = null;
        ClassDeclaration declaration = (ClassDeclaration)ASTNodes.getParent((ASTNode)NodeFinder.perform((ASTNode)this.fASTRoot, (int)this.fType.getNameRange().getOffset(), (int)this.fType.getNameRange().getLength()), ClassDeclaration.class);
        if (declaration != null) {
            listRewriter = astRewrite.getListRewrite((ASTNode)declaration.getBody(), Block.STATEMENTS_PROPERTY);
        }
        if (listRewriter == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 4, "error_input_type_not_found", null));
        }
        if (!this.fSort) {
            iFieldArray = this.fAccessorFields;
            n2 = this.fAccessorFields.length;
            n = 0;
            while (n < n2) {
                IField accessorField = iFieldArray[n];
                this.generateGetterMethod(accessorField, listRewriter);
                this.generateSetterMethod(accessorField, astRewrite, listRewriter);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n;
            }
        }
        iFieldArray = this.fGetterFields;
        n2 = this.fGetterFields.length;
        n = 0;
        while (n < n2) {
            IField getterField = iFieldArray[n];
            this.generateGetterMethod(getterField, listRewriter);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n;
        }
        iFieldArray = this.fSetterFields;
        n2 = this.fSetterFields.length;
        n = 0;
        while (n < n2) {
            IField setterField = iFieldArray[n];
            this.generateSetterMethod(setterField, astRewrite, listRewriter);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n;
        }
        this.fEdit = astRewrite.rewriteAST(this.fDocument, null);
        if (this.fApply) {
            try {
                this.fEdit.apply(this.fDocument);
            }
            catch (BadLocationException | MalformedTreeException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 4, "error file content", null));
            }
        }
        monitor.done();
    }

    public final void setSkipAllExisting(boolean skip) {
        this.fSkipAllExisting = skip;
    }

    public void setSort(boolean sort) {
        this.fSort = sort;
    }

    public final void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }
}

