/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tcp.ssl;

import javax.net.ssl.SSLEngine;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;

public class SSLUtil {
    private static String configFile;
    private static String defaultProtocol;
    private static String defaultKeyPath;
    private static String defaultTrustPath;
    private static String defaultPassPhrase;
    private static int defaultHandShakeTimeOut;
    private static int defaultHandShakeWaitTime;

    static {
        defaultProtocol = "TLSv1.3";
        defaultHandShakeTimeOut = 12;
        defaultHandShakeWaitTime = 60;
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static void setConfigFile(String configFile) {
        SSLUtil.configFile = configFile;
    }

    public static String getDefaultProtocol() {
        return defaultProtocol;
    }

    public static void setDefaultProtocol(String defaultProtocol) {
        SSLUtil.defaultProtocol = defaultProtocol;
    }

    public static String getDefaultKeyPath() {
        return defaultKeyPath;
    }

    public static void setDefaultKeyPath(String defaultKeyPath) {
        SSLUtil.defaultKeyPath = defaultKeyPath;
    }

    public static String getDefaultTrustPath() {
        return defaultTrustPath;
    }

    public static void setDefaultTrustPath(String defaultTrustPath) {
        SSLUtil.defaultTrustPath = defaultTrustPath;
    }

    public static String getDefaultPassPhrase() {
        return defaultPassPhrase;
    }

    public static void setDefaultPassPhrase(String defaultPassPhrase) {
        SSLUtil.defaultPassPhrase = defaultPassPhrase;
    }

    public static int getDefaultHandShakeTimeOut() {
        return defaultHandShakeTimeOut;
    }

    public static void setDefaultHandShakeTimeOut(int defaultHandShakeTimeOut) {
        SSLUtil.defaultHandShakeTimeOut = defaultHandShakeTimeOut;
    }

    public static int getDefaultHandShakeWaitTime() {
        return defaultHandShakeWaitTime;
    }

    public static void setDefaultHandShakeWaitTime(int defaultHandShakeWaitTime) {
        SSLUtil.defaultHandShakeWaitTime = defaultHandShakeWaitTime;
    }

    public static void prepareContainer(IManagedContainer container) {
        TCPUtil.prepareContainer(container);
    }

    public static ITCPAcceptor getAcceptor(IManagedContainer container, String description) {
        return (ITCPAcceptor)container.getElement("org.eclipse.net4j.acceptors", "ssl", description);
    }

    public static ITCPConnector getConnector(IManagedContainer container, String description) {
        return (ITCPConnector)container.getElement("org.eclipse.net4j.connectors", "ssl", description);
    }

    @Deprecated
    public static void setSSLConfigurationFile(String file) {
        SSLUtil.setConfigFile(file);
    }

    @Deprecated
    public static void setDefaultSSLConfiguration(String keyPath, String trustPath, String passPhrase) {
        defaultKeyPath = keyPath;
        defaultTrustPath = trustPath;
        defaultPassPhrase = passPhrase;
    }

    @Deprecated
    public static void setDefaultSSLConfiguration(String keyPath, String trustPath, String passPhrase, int handShakeTimeOut, int handShakeWaitTime) {
        SSLUtil.setDefaultSSLConfiguration(keyPath, trustPath, passPhrase);
        defaultHandShakeTimeOut = handShakeTimeOut;
        defaultHandShakeWaitTime = handShakeWaitTime;
    }

    @Deprecated
    public static SSLEngine createSSLEngine(boolean client, String host, int port) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static int getHandShakeTimeOut() {
        return SSLUtil.getDefaultHandShakeTimeOut();
    }

    @Deprecated
    public static int getHandShakeWaitTime() {
        return SSLUtil.getDefaultHandShakeWaitTime();
    }
}

