/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryInfo;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;

public final class TagRegistryFactoryInfo
implements ITagRegistryFactoryInfo {
    private final String _description;
    private final String _id;
    private final TagRegistryFactory _tagRegistry;
    private final Set<IContentType> _contentTypes;

    TagRegistryFactoryInfo(IConfigurationElement element) throws CoreException {
        this._tagRegistry = (TagRegistryFactory)element.createExecutableExtension("class");
        String localId = element.getAttribute("id");
        this._id = element.getContributor().getName() + "." + localId;
        this._description = element.getAttribute("description");
        IConfigurationElement[] contentTypes = element.getChildren("content-type");
        IContentTypeManager typeManager = Platform.getContentTypeManager();
        this._contentTypes = new HashSet<IContentType>();
        IConfigurationElement[] iConfigurationElementArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contentTypeElement = iConfigurationElementArray[n2];
            String contentTypeId = contentTypeElement.getAttribute("contentTypeId");
            IContentType contentType = typeManager.getContentType(contentTypeId);
            this._contentTypes.add(contentType);
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public TagRegistryFactory getTagRegistryFactory() {
        return this._tagRegistry;
    }

    @Override
    public Set<IContentType> getContentTypes() {
        return Collections.unmodifiableSet(this._contentTypes);
    }
}

