/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceDatabaseGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JPA;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

public final class SourceTableGeneratorAnnotation
extends SourceDatabaseGeneratorAnnotation
implements TableGeneratorAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(ANNOTATION_NAME);
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SourceTableGeneratorAnnotation.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SourceTableGeneratorAnnotation.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> TABLE_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("table");
    private final AnnotationElementAdapter<String> tableAdapter;
    private String table;
    private TextRange tableTextRange;
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("schema");
    private final AnnotationElementAdapter<String> schemaAdapter;
    private String schema;
    private TextRange schemaTextRange;
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("catalog");
    private final AnnotationElementAdapter<String> catalogAdapter;
    private String catalog;
    private TextRange catalogTextRange;
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("pkColumnName");
    private final AnnotationElementAdapter<String> pkColumnNameAdapter;
    private String pkColumnName;
    private TextRange pkColumnNameTextRange;
    private static final DeclarationAnnotationElementAdapter<String> VALUE_COLUMN_NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("valueColumnName");
    private final AnnotationElementAdapter<String> valueColumnNameAdapter;
    private String valueColumnName;
    private TextRange valueColumnNameTextRange;
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_VALUE_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("pkColumnValue");
    private final AnnotationElementAdapter<String> pkColumnValueAdapter;
    private String pkColumnValue;
    private TextRange pkColumnValueTextRange;
    private final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    public SourceTableGeneratorAnnotation(JavaResourceModel parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.tableAdapter = this.buildAdapter(TABLE_ADAPTER);
        this.catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
        this.schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
        this.pkColumnNameAdapter = this.buildAdapter(PK_COLUMN_NAME_ADAPTER);
        this.valueColumnNameAdapter = this.buildAdapter(VALUE_COLUMN_NAME_ADAPTER);
        this.pkColumnValueAdapter = this.buildAdapter(PK_COLUMN_VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.table = this.buildTable(astAnnotation);
        this.tableTextRange = this.buildTableTextRange(astAnnotation);
        this.schema = this.buildSchema(astAnnotation);
        this.schemaTextRange = this.buildSchemaTextRange(astAnnotation);
        this.catalog = this.buildCatalog(astAnnotation);
        this.catalogTextRange = this.buildCatalogTextRange(astAnnotation);
        this.pkColumnName = this.buildPkColumnName(astAnnotation);
        this.pkColumnNameTextRange = this.buildPkColumnNameTextRange(astAnnotation);
        this.valueColumnName = this.buildValueColumnName(astAnnotation);
        this.valueColumnNameTextRange = this.buildValueColumnNameTextRange(astAnnotation);
        this.pkColumnValue = this.buildPkColumnValue(astAnnotation);
        this.pkColumnValueTextRange = this.buildPkColumnValueTextRange(astAnnotation);
        this.uniqueConstraintsContainer.initializeFromContainerAnnotation(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncTable(this.buildTable(astAnnotation));
        this.tableTextRange = this.buildTableTextRange(astAnnotation);
        this.syncSchema(this.buildSchema(astAnnotation));
        this.schemaTextRange = this.buildSchemaTextRange(astAnnotation);
        this.syncCatalog(this.buildCatalog(astAnnotation));
        this.catalogTextRange = this.buildCatalogTextRange(astAnnotation);
        this.syncPkColumnName(this.buildPkColumnName(astAnnotation));
        this.pkColumnNameTextRange = this.buildPkColumnNameTextRange(astAnnotation);
        this.syncValueColumnName(this.buildValueColumnName(astAnnotation));
        this.valueColumnNameTextRange = this.buildValueColumnNameTextRange(astAnnotation);
        this.syncPkColumnValue(this.buildPkColumnValue(astAnnotation));
        this.pkColumnValueTextRange = this.buildPkColumnValueTextRange(astAnnotation);
        this.uniqueConstraintsContainer.synchronize(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.table == null && this.schema == null && this.catalog == null && this.pkColumnName == null && this.valueColumnName == null && this.pkColumnValue == null;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String table) {
        if (ObjectTools.notEquals((Object)this.table, (Object)table)) {
            this.table = table;
            this.tableAdapter.setValue((Object)table);
        }
    }

    private void syncTable(String astTable) {
        String old = this.table;
        this.table = astTable;
        this.firePropertyChanged("table", old, astTable);
    }

    private String buildTable(Annotation astAnnotation) {
        return (String)this.tableAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getTableTextRange() {
        return this.tableTextRange;
    }

    private TextRange buildTableTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(TABLE_ADAPTER, astAnnotation);
    }

    @Override
    public boolean tableTouches(int pos) {
        return this.textRangeTouches(this.tableTextRange, pos);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (ObjectTools.notEquals((Object)this.schema, (Object)schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(Annotation astAnnotation) {
        return (String)this.schemaAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getSchemaTextRange() {
        return this.schemaTextRange;
    }

    private TextRange buildSchemaTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astAnnotation);
    }

    @Override
    public boolean schemaTouches(int pos) {
        return this.textRangeTouches(this.schemaTextRange, pos);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (ObjectTools.notEquals((Object)this.catalog, (Object)catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(Annotation astAnnotation) {
        return (String)this.catalogAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getCatalogTextRange() {
        return this.catalogTextRange;
    }

    private TextRange buildCatalogTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(CATALOG_ADAPTER, astAnnotation);
    }

    @Override
    public boolean catalogTouches(int pos) {
        return this.textRangeTouches(this.catalogTextRange, pos);
    }

    @Override
    public String getPkColumnName() {
        return this.pkColumnName;
    }

    @Override
    public void setPkColumnName(String pkColumnName) {
        if (ObjectTools.notEquals((Object)this.pkColumnName, (Object)pkColumnName)) {
            this.pkColumnName = pkColumnName;
            this.pkColumnNameAdapter.setValue((Object)pkColumnName);
        }
    }

    private void syncPkColumnName(String astPkColumnName) {
        String old = this.pkColumnName;
        this.pkColumnName = astPkColumnName;
        this.firePropertyChanged("pkColumnName", old, astPkColumnName);
    }

    private String buildPkColumnName(Annotation astAnnotation) {
        return (String)this.pkColumnNameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getPkColumnNameTextRange() {
        return this.pkColumnNameTextRange;
    }

    private TextRange buildPkColumnNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(PK_COLUMN_NAME_ADAPTER, astAnnotation);
    }

    @Override
    public boolean pkColumnNameTouches(int pos) {
        return this.textRangeTouches(this.pkColumnNameTextRange, pos);
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    @Override
    public void setValueColumnName(String valueColumnName) {
        if (ObjectTools.notEquals((Object)this.valueColumnName, (Object)valueColumnName)) {
            this.valueColumnName = valueColumnName;
            this.valueColumnNameAdapter.setValue((Object)valueColumnName);
        }
    }

    private void syncValueColumnName(String astValueColumnName) {
        String old = this.valueColumnName;
        this.valueColumnName = astValueColumnName;
        this.firePropertyChanged("valueColumnName", old, astValueColumnName);
    }

    private String buildValueColumnName(Annotation astAnnotation) {
        return (String)this.valueColumnNameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getValueColumnNameTextRange() {
        return this.valueColumnNameTextRange;
    }

    private TextRange buildValueColumnNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(VALUE_COLUMN_NAME_ADAPTER, astAnnotation);
    }

    @Override
    public boolean valueColumnNameTouches(int pos) {
        return this.textRangeTouches(this.valueColumnNameTextRange, pos);
    }

    @Override
    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public void setPkColumnValue(String pkColumnValue) {
        if (ObjectTools.notEquals((Object)this.pkColumnValue, (Object)pkColumnValue)) {
            this.pkColumnValue = pkColumnValue;
            this.pkColumnValueAdapter.setValue((Object)pkColumnValue);
        }
    }

    private void syncPkColumnValue(String astPkColumnValue) {
        String old = this.pkColumnValue;
        this.pkColumnValue = astPkColumnValue;
        this.firePropertyChanged("pkColumnValue", old, astPkColumnValue);
    }

    private String buildPkColumnValue(Annotation astAnnotation) {
        return (String)this.pkColumnValueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getPkColumnValueTextRange() {
        return this.pkColumnValueTextRange;
    }

    private TextRange buildPkColumnValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(PK_COLUMN_VALUE_ADAPTER, astAnnotation);
    }

    @Override
    public boolean pkColumnValueTouches(int pos) {
        return this.textRangeTouches(this.pkColumnValueTextRange, pos);
    }

    @Override
    public ListIterable<UniqueConstraintAnnotation> getUniqueConstraints() {
        return this.uniqueConstraintsContainer.getNestedAnnotations();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintsContainer.getNestedAnnotationsSize();
    }

    @Override
    public UniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.getNestedAnnotation(index);
    }

    @Override
    public UniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.addNestedAnnotation(index);
    }

    UniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return new SourceUniqueConstraintAnnotation((JavaResourceModel)this, this.annotatedElement, this.buildUniqueConstraintIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildUniqueConstraintIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "uniqueConstraints", index, JPA.UNIQUE_CONSTRAINT);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintsContainer.removeNestedAnnotation(index);
    }

    private static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceTableGeneratorAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SourceTableGeneratorAnnotation.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    class UniqueConstraintsAnnotationContainer
    extends SourceModel.AnnotationContainer<UniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
            super((SourceModel)SourceTableGeneratorAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "uniqueConstraints";
        }

        protected String getElementName() {
            return "uniqueConstraints";
        }

        protected String getNestedAnnotationName() {
            return UniqueConstraintAnnotation.ANNOTATION_NAME;
        }

        protected UniqueConstraintAnnotation buildNestedAnnotation(int index) {
            return SourceTableGeneratorAnnotation.this.buildUniqueConstraint(index);
        }
    }
}

