/*******************************************************************************
 * Copyright (c) 2008 xored software, Inc.  
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0  
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Andrei Sobolev)
 *******************************************************************************/
package org.eclipse.dltk.tcl.ast;

import org.eclipse.dltk.tcl.definitions.Argument;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Argument Match</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.dltk.tcl.ast.ArgumentMatch#getDefinition <em>Definition</em>}</li>
 *   <li>{@link org.eclipse.dltk.tcl.ast.ArgumentMatch#getArguments <em>Arguments</em>}</li>
 * </ul>
 *
 * @see org.eclipse.dltk.tcl.ast.AstPackage#getArgumentMatch()
 * @model
 * @generated
 */
public interface ArgumentMatch extends EObject {
	/**
	 * Returns the value of the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Definition</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Definition</em>' reference.
	 * @see #setDefinition(Argument)
	 * @see org.eclipse.dltk.tcl.ast.AstPackage#getArgumentMatch_Definition()
	 * @model
	 * @generated
	 */
	Argument getDefinition();

	/**
	 * Sets the value of the '{@link org.eclipse.dltk.tcl.ast.ArgumentMatch#getDefinition <em>Definition</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Definition</em>' reference.
	 * @see #getDefinition()
	 * @generated
	 */
	void setDefinition(Argument value);

	/**
	 * Returns the value of the '<em><b>Arguments</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.dltk.tcl.ast.TclArgument}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Arguments</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Arguments</em>' reference list.
	 * @see org.eclipse.dltk.tcl.ast.AstPackage#getArgumentMatch_Arguments()
	 * @model
	 * @generated
	 */
	EList<TclArgument> getArguments();

} // ArgumentMatch
