/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMFileSet;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IRecordIterator;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class IndexFileSet
implements IIndexFileSet {
    public static boolean sDEBUG;
    private IIndexFileSet fInverse;
    private final HashMap<IIndexFragment, IIndexFragmentFileSet> fSubSets = new HashMap();
    private final Map<IBinding, Boolean> fDeclarationContainmentCache = new HashMap<IBinding, Boolean>();
    private long timingContainsDeclarationNanos;

    @Override
    public void add(IIndexFile indexFile) {
        IIndexFragmentFile fragFile = (IIndexFragmentFile)indexFile;
        IIndexFragment frag = fragFile.getIndexFragment();
        IIndexFragmentFileSet subSet = this.fSubSets.get(frag);
        if (subSet == null) {
            subSet = frag.createFileSet();
            this.fSubSets.put(frag, subSet);
        }
        subSet.add(fragFile);
        this.fDeclarationContainmentCache.clear();
    }

    @Override
    public void remove(IIndexFile indexFile) {
        IIndexFragmentFile fragmentFile = (IIndexFragmentFile)indexFile;
        IIndexFragment fragment = fragmentFile.getIndexFragment();
        IIndexFragmentFileSet subSet = this.fSubSets.get(fragment);
        if (subSet != null) {
            subSet.remove(fragmentFile);
            this.fDeclarationContainmentCache.clear();
        }
    }

    @Override
    public boolean containsDeclaration(IIndexBinding binding) {
        Boolean cachedValue = this.fDeclarationContainmentCache.get(binding);
        if (cachedValue != null) {
            return cachedValue;
        }
        long startTime = sDEBUG ? System.nanoTime() : 0L;
        boolean contains = this.computeContainsDeclaration(binding);
        this.fDeclarationContainmentCache.put(binding, contains);
        if (sDEBUG) {
            this.timingContainsDeclarationNanos += System.nanoTime() - startTime;
        }
        return contains;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean computeContainsDeclaration(IIndexBinding binding) {
        int iterationCount = 0;
        for (Map.Entry<IIndexFragment, IIndexFragmentFileSet> entry : this.fSubSets.entrySet()) {
            IIndexFragment fragment = entry.getKey();
            IIndexFragmentFileSet fragmentFileSet = entry.getValue();
            try {
                long nameRecord;
                if (fragmentFileSet.isEmpty() || !(fragmentFileSet instanceof PDOMFileSet) || !(fragment instanceof PDOM)) continue;
                PDOM pdom = (PDOM)fragment;
                PDOMFileSet pdomFileSet = (PDOMFileSet)fragmentFileSet;
                Database db = pdom.getDB();
                IRecordIterator nameIterator = pdom.getDeclarationsDefintitionsRecordIterator(binding);
                HashSet<Long> visited = null;
                while ((nameRecord = nameIterator.next()) != 0L) {
                    if (++iterationCount >= 1000 && visited == null) {
                        visited = new HashSet<Long>();
                    }
                    if (visited != null && !visited.add(nameRecord)) {
                        this.logInvalidNameChain(pdom, binding);
                        return false;
                    }
                    long fileRecord = PDOMName.getFileRecord(db, nameRecord);
                    if (!pdomFileSet.containsFile(fileRecord)) continue;
                    if (sDEBUG && iterationCount >= 200) {
                        System.out.println(String.format("IndexFileSet: %s (%s) found after %d iterations", String.join((CharSequence)"::", binding.getQualifiedName()), binding.getClass().getSimpleName(), iterationCount));
                    }
                    return true;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        if (sDEBUG && iterationCount >= 200) {
            System.out.println(String.format("IndexFileSet: %s (%s) not found after %d iterations", String.join((CharSequence)"::", binding.getQualifiedName()), binding.getClass().getSimpleName(), iterationCount));
        }
        return false;
    }

    private void logInvalidNameChain(PDOM pdom, IIndexBinding binding) {
        try {
            PDOMBinding pdomBinding = (PDOMBinding)binding;
            String[] stringArray = new String[]{"declarations", "definitions"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMName first;
                String listType = stringArray[n2];
                StringBuilder nameChain = new StringBuilder();
                HashSet<PDOMName> visited = new HashSet<PDOMName>();
                PDOMName name = first = listType.equals("declarations") ? pdomBinding.getFirstDeclaration() : pdomBinding.getFirstDefinition();
                while (name != null) {
                    if (nameChain.length() != 0) {
                        nameChain.append('\n');
                    }
                    nameChain.append(String.format("%s @%d", String.valueOf(name.getSimpleID()), name.getRecord()));
                    PDOMBinding nameBinding = name.getBinding();
                    if (!nameBinding.equals(binding)) {
                        nameChain.append(String.format(" belongs to %s (%s) @%d", String.join((CharSequence)"::", nameBinding.getQualifiedName()), nameBinding.getClass().getSimpleName(), nameBinding.getRecord()));
                    }
                    if (!visited.add(name)) {
                        CCorePlugin.log(String.format("IndexFileSet: %s (%s) @%d - list of %s contains a cycle:\n%s", String.join((CharSequence)"::", binding.getQualifiedName()), binding.getClass().getSimpleName(), pdomBinding.getRecord(), listType, nameChain.toString()));
                        return;
                    }
                    name = name.getNextInBinding();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public long getTimingContainsDeclarationNanos() {
        return this.timingContainsDeclarationNanos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsNonLocalDeclaration(IBinding binding, IIndexFragment ignore) {
        for (Map.Entry<IIndexFragment, IIndexFragmentFileSet> entry : this.fSubSets.entrySet()) {
            try {
                IIndexFragmentName[] names;
                IIndexFragment fragment = entry.getKey();
                IIndexFragmentFileSet subset = entry.getValue();
                if (fragment == ignore) continue;
                IIndexFragmentName[] iIndexFragmentNameArray = names = fragment.findNames(binding, 65539);
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFragmentName name = iIndexFragmentNameArray[n2];
                    try {
                        if (subset.contains((IIndexFragmentFile)name.getFile())) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsNonLocalDeclaration(IBinding binding, IIndexFileLocation ignore) {
        for (Map.Entry<IIndexFragment, IIndexFragmentFileSet> entry : this.fSubSets.entrySet()) {
            try {
                IIndexFragmentName[] names;
                IIndexFragment fragment = entry.getKey();
                IIndexFragmentFileSet subset = entry.getValue();
                IIndexFragmentName[] iIndexFragmentNameArray = names = fragment.findNames(binding, 65539);
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFragmentName name = iIndexFragmentNameArray[n2];
                    try {
                        IIndexFile file = name.getFile();
                        if (!file.getLocation().equals(ignore) && subset.contains((IIndexFragmentFile)file)) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    @Override
    public IBinding[] filterFileLocalBindings(IBinding[] bindings) {
        return this.filterFileLocalBindings(bindings, false);
    }

    public IBinding[] filterFileLocalBindings(IBinding[] bindings, boolean invert) {
        int cardinality;
        if (bindings == null || bindings.length == 0) {
            return bindings;
        }
        BitSet ok = new BitSet(bindings.length);
        if (invert) {
            ok.set(0, bindings.length);
        }
        int i = 0;
        while (i < bindings.length) {
            IBinding binding = bindings[i];
            if (binding != null) {
                IIndexFragmentBinding fb = binding instanceof IIndexFragmentBinding ? (IIndexFragmentBinding)binding : (IIndexFragmentBinding)binding.getAdapter(IIndexFragmentBinding.class);
                try {
                    if (fb != null && fb.isFileLocal()) {
                        IIndexFragmentFileSet subSet = this.fSubSets.get(fb.getFragment());
                        if (subSet != null && subSet.containsFileOfLocalBinding(fb)) {
                            ok.set(i);
                        }
                    } else {
                        ok.set(i);
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
        if (invert) {
            ok.flip(0, bindings.length);
        }
        if ((cardinality = ok.cardinality()) == bindings.length) {
            return bindings;
        }
        IBinding[] result = new IBinding[cardinality];
        int j = ok.nextSetBit(0);
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = bindings[j];
            j = ok.nextSetBit(j + 1);
            ++i2;
        }
        return result;
    }

    @Override
    public boolean contains(IIndexFile file) throws CoreException {
        return this.contains(file, false);
    }

    public boolean contains(IIndexFile file, boolean invert) throws CoreException {
        if (!(file instanceof IIndexFragmentFile)) {
            return invert;
        }
        IIndexFragmentFile fragmentFile = (IIndexFragmentFile)file;
        IIndexFragmentFileSet subSet = this.fSubSets.get(fragmentFile.getIndexFragment());
        if (subSet != null && subSet.contains(fragmentFile)) {
            return !invert;
        }
        return invert;
    }

    @Override
    public IIndexFileSet invert() {
        if (this.fInverse == null) {
            this.fInverse = new IIndexFileSet(){

                @Override
                public IIndexFileSet invert() {
                    return IndexFileSet.this;
                }

                @Override
                public IBinding[] filterFileLocalBindings(IBinding[] bindings) {
                    return IndexFileSet.this.filterFileLocalBindings(bindings, true);
                }

                @Override
                public boolean containsDeclaration(IIndexBinding binding) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsNonLocalDeclaration(IBinding binding, IIndexFragment ignore) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(IIndexFile file) throws CoreException {
                    return IndexFileSet.this.contains(file, true);
                }

                @Override
                public void add(IIndexFile indexFile) {
                    Assert.isLegal((boolean)false);
                }

                @Override
                public void remove(IIndexFile indexFile) {
                    Assert.isLegal((boolean)false);
                }
            };
        }
        return this.fInverse;
    }
}

