/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.cloudio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.zest.cloudio.Messages;
import org.eclipse.zest.cloudio.Word;
import org.eclipse.zest.cloudio.layout.DefaultLayouter;
import org.eclipse.zest.cloudio.layout.ILayouter;
import org.eclipse.zest.cloudio.util.CloudMatrix;
import org.eclipse.zest.cloudio.util.RectTree;
import org.eclipse.zest.cloudio.util.SmallRect;

public class TagCloud
extends Canvas {
    private final int accuracy;
    private final int maxSize;
    private final Rectangle cloudArea;
    private int maxFontSize = 100;
    private final GC gc;
    private Color highlightColor;
    private Word currentWord;
    private int opacity = 255;
    private final Point origin = new Point(0, 0);
    private Image textLayerImage;
    private Image selectionLayerImage;
    private Image zoomLayerImage;
    private List<Word> wordsToUse;
    private boolean initialized = false;
    private double currentZoom = 1.0;
    private int minFontSize = 12;
    private Set<Word> selection = new HashSet<Word>();
    private CloudMatrix cloudMatrix;
    private ILayouter layouter;
    private int boost;
    private Point regionOffset;
    private int antialias = 1;
    private float boostFactor;
    private Listener hBarListener;
    private Listener resizeListener;
    private Listener paintListener;
    private Listener mouseTrackListener;
    private Listener mouseMoveListener;
    private Listener mouseUpListener;
    private Listener mouseDCListener;
    private Listener mouseDownListener;
    private Listener mouseWheelListener;
    private Listener vBarListener;
    private final Set<EventListener> mouseWheelListeners = new HashSet<EventListener>();
    private final Set<EventListener> mouseTrackListeners = new HashSet<EventListener>();
    private final Set<EventListener> mouseMoveListeners = new HashSet<EventListener>();
    private final Set<EventListener> mouseListeners = new HashSet<EventListener>();
    private final Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();
    private ImageData mask;

    public TagCloud(Composite parent, int style, int accuracy, int maxSize) {
        super(parent, style);
        Assert.isLegal((accuracy > 0 ? 1 : 0) != 0, (String)("Parameter accuracy must be greater than 0, but was " + accuracy));
        Assert.isLegal((maxSize > 0 ? 1 : 0) != 0, (String)("Parameter maxSize must be greater than 0, but was " + maxSize));
        int tmp = maxSize;
        while (tmp > accuracy) {
            tmp /= 2;
        }
        Assert.isLegal((tmp == accuracy ? 1 : 0) != 0, (String)"Paramter maxSize must be a ");
        this.accuracy = accuracy;
        this.maxSize = maxSize;
        this.cloudArea = new Rectangle(0, 0, maxSize, maxSize);
        this.highlightColor = new Color((Device)this.getDisplay(), Display.getDefault().getSystemColor(3).getRGB());
        this.gc = new GC((Drawable)this);
        this.layouter = new DefaultLayouter(accuracy, accuracy);
        this.setBackground(new Color((Device)this.getDisplay(), Display.getDefault().getSystemColor(2).getRGB()));
        this.initListeners();
        this.textLayerImage = new Image((Device)this.getDisplay(), 100, 100);
        this.zoomFit();
        this.addDisposeListener(e -> this.internalDispose());
    }

    public TagCloud(Composite parent, int style) {
        this(parent, style, 5, 5120);
    }

    private void internalDispose() {
        this.removeListeners();
        this.textLayerImage.dispose();
        if (this.selectionLayerImage != null) {
            this.selectionLayerImage.dispose();
        }
        if (this.zoomLayerImage != null) {
            this.zoomLayerImage.dispose();
        }
        if (!this.isDisposed()) {
            this.gc.dispose();
        }
        super.dispose();
    }

    private void removeListeners() {
        if (this.isDisposed()) {
            return;
        }
        this.removeListener(9, this.paintListener);
        if (this.hBarListener != null) {
            this.removeListener(256, this.hBarListener);
        }
        if (this.vBarListener != null) {
            this.removeListener(512, this.vBarListener);
        }
        this.removeListener(8, this.mouseDCListener);
        this.removeListener(3, this.mouseDownListener);
        this.removeListener(5, this.mouseTrackListener);
        this.removeListener(4, this.mouseUpListener);
        this.removeListener(11, this.resizeListener);
        this.removeListener(5, this.mouseMoveListener);
        this.removeListener(37, this.mouseWheelListener);
    }

    public void zoomReset() {
        this.checkWidget();
        if (this.selectionLayerImage == null) {
            return;
        }
        this.zoomLayerImage = new Image((Device)this.getDisplay(), this.selectionLayerImage.getBounds().width, this.selectionLayerImage.getBounds().height);
        GC gc = new GC((Drawable)this.zoomLayerImage);
        gc.drawImage(this.selectionLayerImage, 0, 0);
        gc.dispose();
        this.currentZoom = 1.0;
        this.updateScrollbars();
        this.redraw();
    }

    public double getZoom() {
        this.checkWidget();
        return this.currentZoom;
    }

    public void zoomFit() {
        this.checkWidget();
        if (this.selectionLayerImage == null) {
            return;
        }
        Rectangle imageBound = this.selectionLayerImage.getBounds();
        Rectangle destRect = this.getClientArea();
        double sx = (double)destRect.width / (double)imageBound.width;
        double sy = (double)destRect.height / (double)imageBound.height;
        this.currentZoom = Math.min(sx, sy);
        this.zoom(this.currentZoom);
    }

    private void zoom(double s) {
        this.checkWidget();
        if (this.selectionLayerImage == null) {
            return;
        }
        if (s < 0.1) {
            s = 0.1;
        }
        if (s > 3.0) {
            s = 3.0;
        }
        int width = (int)((double)this.selectionLayerImage.getBounds().width * s);
        int height = (int)((double)this.selectionLayerImage.getBounds().height * s);
        if (width == 0 || height == 0) {
            return;
        }
        if (this.zoomLayerImage != null) {
            this.zoomLayerImage.dispose();
        }
        this.zoomLayerImage = new Image((Device)this.getDisplay(), width, height);
        Transform tf = new Transform((Device)this.getDisplay());
        tf.scale((float)s, (float)s);
        GC gc = new GC((Drawable)this.zoomLayerImage);
        gc.setTransform(tf);
        gc.drawImage(this.selectionLayerImage, 0, 0);
        gc.dispose();
        tf.dispose();
        this.currentZoom = s;
        this.updateScrollbars();
        this.redraw();
    }

    public void zoomIn() {
        this.checkWidget();
        this.zoom(this.currentZoom * 1.1);
        this.redraw();
    }

    public void zoomOut() {
        this.checkWidget();
        this.zoom(this.currentZoom * 0.9);
        this.redraw();
    }

    protected Rectangle getCloudArea() {
        return this.cloudArea;
    }

    private float getFontSize(Word word) {
        float size = (float)(word.weight * (double)this.maxFontSize);
        return size += (float)this.minFontSize;
    }

    private void drawWord(GC gc, Word word, Color color) {
        gc.setForeground(color);
        Font font = new Font(gc.getDevice(), word.getFontData());
        gc.setFont(font);
        gc.setAntialias(this.antialias);
        gc.setAlpha(this.opacity);
        Point stringExtent = word.stringExtent;
        gc.setForeground(color);
        int xOffset = word.x - this.regionOffset.x;
        int yOffset = word.y - this.regionOffset.y;
        double radian = Math.toRadians(word.angle);
        double sin = Math.abs(Math.sin(radian));
        double cos = Math.abs(Math.cos(radian));
        int y = (int)(cos * (double)stringExtent.y + sin * (double)stringExtent.x);
        Transform t = new Transform(gc.getDevice());
        if (word.angle < 0.0f) {
            t.translate((float)xOffset, (float)(yOffset + y - (int)(cos * (double)stringExtent.y)));
        } else {
            t.translate((float)(xOffset + (int)(sin * (double)stringExtent.y)), (float)yOffset);
        }
        t.rotate(word.angle);
        gc.setTransform(t);
        gc.drawString(word.string, 0, 0, true);
        gc.setTransform(null);
        t.dispose();
        font.dispose();
    }

    protected void calcExtents(IProgressMonitor monitor) {
        this.checkWidget();
        if (monitor != null) {
            monitor.subTask(Messages.TagCloud_CalculatingWordBoundaries);
        }
        if (this.wordsToUse == null) {
            return;
        }
        double step = 80.0 / (double)this.wordsToUse.size();
        double current = 0.0;
        int next = 10;
        Color color = this.gc.getDevice().getSystemColor(2);
        for (Word word : this.wordsToUse) {
            FontData[] fontData = word.getFontData();
            int fontSize = (int)this.getFontSize(word);
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                data.setHeight(fontSize);
                ++n2;
            }
            Font font = new Font(this.gc.getDevice(), fontData);
            this.gc.setFont(font);
            Point stringExtent = this.gc.stringExtent(word.string);
            FontMetrics fm = this.gc.getFontMetrics();
            stringExtent.y = fm.getHeight();
            double radian = Math.toRadians(word.angle);
            double sin = Math.abs(Math.sin(radian));
            double cos = Math.abs(Math.cos(radian));
            int x = (int)(cos * (double)stringExtent.x + sin * (double)stringExtent.y);
            int y = (int)(cos * (double)stringExtent.y + sin * (double)stringExtent.x);
            ImageData id = this.createImageData(word, font, stringExtent, sin, cos, x, y, color);
            this.calcWordExtents(word, id);
            font.dispose();
            if (monitor == null || !((current += step) > (double)next)) continue;
            monitor.worked(5);
            next += 5;
        }
        Collections.sort(this.wordsToUse, (o1, o2) -> o2.width * o2.height - o1.width * o1.height);
        short i = 1;
        for (Word word : this.wordsToUse) {
            word.id = i;
            i = (short)(i + 1);
        }
    }

    private ImageData createImageData(Word word, Font font, Point stringExtent, double sin, double cos, int x, int y, Color color) {
        Image img = new Image(null, x, y);
        word.width = x;
        word.height = y;
        word.stringExtent = stringExtent;
        GC g = new GC((Drawable)img);
        g.setAntialias(this.antialias);
        g.setForeground(color);
        Transform t = new Transform(img.getDevice());
        if (word.angle < 0.0f) {
            t.translate(0.0f, (float)(img.getBounds().height - (int)(cos * (double)stringExtent.y)));
        } else {
            t.translate((float)((int)(sin * (double)stringExtent.y)), 0.0f);
        }
        t.rotate(word.angle);
        g.setTransform(t);
        g.setFont(font);
        g.drawString(word.string, 0, 0, false);
        int max = Math.max(x, y);
        int tmp = this.maxSize;
        while (max < tmp) {
            tmp /= 2;
        }
        SmallRect root = new SmallRect(0, 0, tmp *= 2, tmp);
        word.tree = new RectTree(root, this.accuracy);
        ImageData id = img.getImageData();
        t.dispose();
        g.dispose();
        img.dispose();
        return id;
    }

    private void calcWordExtents(Word word, ImageData id) {
        int[] pixels = new int[id.width];
        PaletteData palette = id.palette;
        HashSet<SmallRect> inserted = new HashSet<SmallRect>();
        int y = 0;
        while (y < id.height) {
            id.getPixels(0, y, id.width, pixels, 0);
            int i = 0;
            while (i < pixels.length) {
                int pixel = pixels[i];
                int r = pixel & palette.redMask;
                r = palette.redShift < 0 ? r >>> -palette.redShift : r << palette.redShift;
                int g = pixel & palette.greenMask;
                g = palette.greenShift < 0 ? g >>> -palette.greenShift : g << palette.greenShift;
                int b = pixel & palette.blueMask;
                int n = b = palette.blueShift < 0 ? b >>> -palette.blueShift : b << palette.blueShift;
                if (r < 250 || g < 250 || b < 250) {
                    SmallRect rect = new SmallRect(i / this.accuracy * this.accuracy, y / this.accuracy * this.accuracy, this.accuracy, this.accuracy);
                    if (!inserted.contains(rect)) {
                        word.tree.insert(rect, word.id);
                        inserted.add(rect);
                    }
                    i += this.accuracy - 1;
                }
                ++i;
            }
            ++y;
        }
        word.tree.releaseRects();
    }

    protected int layoutWords(Collection<Word> wordsToUse, IProgressMonitor monitor) {
        this.checkWidget();
        if (monitor != null) {
            monitor.subTask(Messages.TagCloud_PlacingWords);
        }
        Rectangle r = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        Rectangle cloudArea = this.getCloudArea();
        int w = cloudArea.width;
        int h = cloudArea.height;
        double current = 0.0;
        int next = 10;
        Image tmpImage = new Image((Device)this.getDisplay(), w, h);
        GC gc = new GC((Drawable)tmpImage);
        gc.setBackground(this.getBackground());
        gc.setTextAntialias(1);
        gc.setBackground(this.getBackground());
        gc.fillRectangle(tmpImage.getBounds());
        int success = 0;
        if (wordsToUse != null) {
            double step = 100.0 / (double)wordsToUse.size();
            GC g = gc;
            for (Word word : wordsToUse) {
                Point point = this.layouter.getInitialOffset(word, cloudArea);
                boolean result = this.layouter.layout(point, word, cloudArea, this.cloudMatrix);
                if (!result) {
                    System.err.println("Failed to place " + word.string);
                    continue;
                }
                ++success;
                if (word.x < r.x) {
                    r.x = word.x;
                }
                if (word.y < r.y) {
                    r.y = word.y;
                }
                if (word.x + word.width > r.width) {
                    r.width = word.x + word.width;
                }
                if (word.y + word.height > r.height) {
                    r.height = word.y + word.height;
                }
                Word wrd = word;
                this.drawWord(g, wrd, wrd.getColor());
                current += step;
                if (!(current > (double)next)) continue;
                next += 5;
                if (monitor == null) continue;
                monitor.worked(5);
            }
        }
        gc.dispose();
        if (success == 0) {
            return success;
        }
        if (this.textLayerImage != null) {
            this.textLayerImage.dispose();
        }
        this.textLayerImage = new Image((Device)this.getDisplay(), r.width - r.x, r.height - r.y);
        gc = new GC((Drawable)this.textLayerImage);
        gc.drawImage(tmpImage, r.x, r.y, r.width - r.x, r.height - r.y, 0, 0, this.textLayerImage.getBounds().width, this.textLayerImage.getBounds().height);
        this.regionOffset = new Point(r.x, r.y);
        tmpImage.dispose();
        gc.dispose();
        Rectangle textLayerBounds = this.textLayerImage.getBounds();
        this.selectionLayerImage = new Image((Device)this.getDisplay(), textLayerBounds.width, textLayerBounds.height);
        gc = new GC((Drawable)this.selectionLayerImage);
        gc.drawImage(this.textLayerImage, 0, 0);
        gc.dispose();
        this.zoomFit();
        if (monitor != null) {
            monitor.worked(10);
        }
        return success;
    }

    public int setWords(List<Word> values, IProgressMonitor monitor) {
        this.checkWidget();
        Assert.isLegal((values != null ? 1 : 0) != 0, (String)"List must not be null!");
        for (Word word : values) {
            Assert.isLegal((word != null ? 1 : 0) != 0, (String)"Word must not be null!");
            Assert.isLegal((word.string != null ? 1 : 0) != 0, (String)"Word must define a string!");
            Assert.isLegal((word.getColor() != null ? 1 : 0) != 0, (String)"A word must define a color");
            Assert.isLegal((word.getFontData() != null ? 1 : 0) != 0, (String)"A word must define a fontdata array");
            Assert.isLegal((word.weight >= 0.0 ? 1 : 0) != 0, (String)("Word weight must be between 0 and 1 (inclusive), but value was " + word.weight));
            Assert.isLegal((word.weight <= 1.0 ? 1 : 0) != 0, (String)("Word weight must be between 0 and 1 (inclusive), but value was " + word.weight));
            Assert.isLegal((word.angle >= -90.0f ? 1 : 0) != 0, (String)("Angle must be between -90 and +90 (inclusive), but was " + word.angle));
            Assert.isLegal((word.angle <= 90.0f ? 1 : 0) != 0, (String)("Angle must be between -90 and +90 (inclusive), but was " + word.angle));
        }
        this.wordsToUse = new ArrayList<Word>(values);
        if (this.boost > 0) {
            double factor = this.boostFactor;
            int i = this.boost;
            for (Word word : values) {
                if (factor <= 1.0) break;
                word.weight *= factor;
                factor -= 0.2;
                if (--i == 0) break;
            }
        }
        return this.layoutCloud(monitor, true);
    }

    private void resetLayout() {
        if (this.cloudMatrix == null) {
            this.cloudMatrix = new CloudMatrix(this.maxSize, this.accuracy);
        } else {
            this.cloudMatrix.reset();
        }
        if (this.mask != null) {
            this.resetMask();
        }
    }

    public void setBackgroundMask(ImageData bgData) {
        if (this.mask != null) {
            this.mask = null;
        }
        if (bgData != null) {
            Image img = new Image(null, this.cloudArea.width, this.cloudArea.height);
            GC gc = new GC((Drawable)img);
            Image tmp = new Image(null, bgData);
            gc.drawImage(tmp, 0, 0, tmp.getBounds().width, tmp.getBounds().height, 0, 0, this.cloudArea.width, this.cloudArea.height);
            ImageData id = img.getImageData();
            tmp.dispose();
            img.dispose();
            gc.dispose();
            this.mask = id;
        }
    }

    private void resetMask() {
        Word word = new Word("mask");
        word.tree = new RectTree(new SmallRect(0, 0, this.cloudArea.width, this.cloudArea.height), this.accuracy);
        this.calcWordExtents(word, this.mask);
        word.tree.place(this.cloudMatrix, RectTree.BACKGROUND);
    }

    private void initListeners() {
        ScrollBar vBar;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            this.hBarListener = e -> {
                int hSelection = hBar.getSelection();
                int destX = -hSelection - this.origin.x;
                Rectangle rect = this.zoomLayerImage.getBounds();
                this.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                this.origin.x = -hSelection;
            };
            hBar.addListener(13, this.hBarListener);
        }
        if ((vBar = this.getVerticalBar()) != null) {
            this.vBarListener = e -> {
                int vSelection = vBar.getSelection();
                int destY = -vSelection - this.origin.y;
                Rectangle rect = this.zoomLayerImage.getBounds();
                this.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                this.origin.y = -vSelection;
            };
            vBar.addListener(13, this.vBarListener);
        }
        this.resizeListener = e -> {
            this.updateScrollbars();
            this.redraw();
        };
        this.addListener(11, this.resizeListener);
        this.paintListener = e -> {
            int marginHeight;
            GC gc = e.gc;
            if (this.zoomLayerImage == null) {
                return;
            }
            Rectangle rect = this.zoomLayerImage.getBounds();
            Rectangle client = this.getClientArea();
            int marginWidth = client.width - rect.width;
            gc.setBackground(this.getBackground());
            if (marginWidth > 0) {
                gc.fillRectangle(rect.width, 0, marginWidth, client.height);
            }
            if ((marginHeight = client.height - rect.height) > 0) {
                gc.fillRectangle(0, rect.height, client.width, marginHeight);
            }
            gc.drawImage(this.zoomLayerImage, this.origin.x, this.origin.y);
        };
        this.addListener(9, this.paintListener);
        this.mouseTrackListener = event -> {
            Word word = this.getWordAt(new Point(event.x, event.y));
            MouseEvent me = this.createMouseEvent(event, word);
            if (this.currentWord != null) {
                if (word == this.currentWord) {
                    TagCloud.fireMouseEvent(me, 32, this.mouseTrackListeners);
                } else {
                    this.currentWord = null;
                    TagCloud.fireMouseEvent(me, 7, this.mouseTrackListeners);
                }
            }
            if (this.currentWord == null && word != null) {
                this.currentWord = word;
                TagCloud.fireMouseEvent(me, 6, this.mouseTrackListeners);
            }
        };
        this.addListener(5, this.mouseTrackListener);
        this.mouseMoveListener = event -> {
            Word word = this.getWordAt(new Point(event.x, event.y));
            MouseEvent me = this.createMouseEvent(event, word);
            TagCloud.fireMouseEvent(me, 5, this.mouseMoveListeners);
        };
        this.addListener(5, this.mouseMoveListener);
        this.mouseUpListener = event -> {
            Word word = this.getWordAt(new Point(event.x, event.y));
            MouseEvent me = this.createMouseEvent(event, word);
            TagCloud.fireMouseEvent(me, 4, this.mouseListeners);
        };
        this.addListener(4, this.mouseUpListener);
        this.mouseDCListener = event -> {
            Word word = this.getWordAt(new Point(event.x, event.y));
            MouseEvent me = this.createMouseEvent(event, word);
            TagCloud.fireMouseEvent(me, 8, this.mouseListeners);
        };
        this.addListener(8, this.mouseDCListener);
        this.mouseDownListener = event -> {
            Word word = this.getWordAt(new Point(event.x, event.y));
            MouseEvent me = this.createMouseEvent(event, word);
            TagCloud.fireMouseEvent(me, 3, this.mouseListeners);
        };
        this.addListener(3, this.mouseDownListener);
        this.mouseWheelListener = event -> {
            Word word = this.getWordAt(new Point(event.x, event.y));
            MouseEvent me = this.createMouseEvent(event, word);
            TagCloud.fireMouseEvent(me, 37, this.mouseWheelListeners);
        };
        this.addListener(37, this.mouseWheelListener);
    }

    private Word getWordAt(Point point) {
        if (this.cloudMatrix == null || this.regionOffset == null) {
            return null;
        }
        Point translatedMousePos = this.translateMousePos(point.x, point.y);
        translatedMousePos.x += this.regionOffset.x;
        translatedMousePos.y += this.regionOffset.y;
        int x = translatedMousePos.x / this.accuracy;
        int y = translatedMousePos.y / this.accuracy;
        if (x >= this.maxSize || y >= this.maxSize) {
            return null;
        }
        short wordId = this.cloudMatrix.get(x, y);
        if (wordId > 0) {
            return this.wordsToUse.get(wordId - 1);
        }
        return null;
    }

    private Point translateMousePos(int x, int y) {
        Point point = new Point(x - this.origin.x, y - this.origin.y);
        point.x = (int)((double)point.x / this.currentZoom);
        point.y = (int)((double)point.y / this.currentZoom);
        return point;
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        this.mouseListeners.add((EventListener)listener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        this.mouseMoveListeners.add((EventListener)listener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        this.mouseTrackListeners.add((EventListener)listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        this.mouseWheelListeners.add((EventListener)listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        Assert.isLegal((listener != null ? 1 : 0) != 0);
        this.selectionListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        this.mouseListeners.remove(listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        this.mouseMoveListeners.remove(listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        this.mouseTrackListeners.remove(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        this.mouseWheelListeners.remove(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.selectionListeners.remove(listener);
    }

    private MouseEvent createMouseEvent(Event event, Word word) {
        MouseEvent me = new MouseEvent(event);
        me.x = event.x - this.origin.x;
        me.y = event.y - this.origin.y;
        me.data = word;
        me.widget = this;
        me.display = Display.getCurrent();
        return me;
    }

    private static void fireMouseEvent(MouseEvent me, int type, Set<EventListener> listeners) {
        for (EventListener listener : listeners) {
            if (listener instanceof MouseListener) {
                MouseListener ml = (MouseListener)listener;
                switch (type) {
                    case 4: {
                        ml.mouseUp(me);
                        break;
                    }
                    case 8: {
                        ml.mouseDoubleClick(me);
                        break;
                    }
                    case 3: {
                        ml.mouseDown(me);
                    }
                }
            }
            if (listener instanceof MouseTrackListener) {
                MouseTrackListener ml = (MouseTrackListener)listener;
                switch (type) {
                    case 6: {
                        ml.mouseEnter(me);
                        break;
                    }
                    case 7: {
                        ml.mouseExit(me);
                        break;
                    }
                    case 32: {
                        ml.mouseHover(me);
                    }
                }
            }
            if (listener instanceof MouseMoveListener) {
                MouseMoveListener ml = (MouseMoveListener)listener;
                switch (type) {
                    case 5: {
                        ml.mouseMove(me);
                    }
                }
            }
            if (!(listener instanceof MouseWheelListener)) continue;
            MouseWheelListener ml = (MouseWheelListener)listener;
            switch (type) {
                case 37: {
                    ml.mouseScrolled(me);
                }
            }
        }
    }

    public void setSelection(Set<Word> words) {
        this.checkWidget();
        Assert.isNotNull(words, (String)"Selection must not be null!");
        if (this.wordsToUse == null) {
            return;
        }
        HashSet<Word> selection = new HashSet<Word>(words);
        selection.retainAll(this.wordsToUse);
        int w = this.textLayerImage.getBounds().width;
        int h = this.textLayerImage.getBounds().height;
        if (this.selectionLayerImage != null) {
            this.selectionLayerImage.dispose();
        }
        this.selectionLayerImage = new Image((Device)this.getDisplay(), w, h);
        GC gc = new GC((Drawable)this.selectionLayerImage);
        gc.drawImage(this.textLayerImage, 0, 0);
        for (Word word : selection) {
            this.drawWord(gc, word, this.highlightColor);
        }
        if (!selection.equals(this.selection)) {
            this.selection = selection;
            this.fireSelectionChanged();
        }
        gc.dispose();
        this.zoom(this.currentZoom);
        this.redraw();
    }

    private void fireSelectionChanged() {
        Event e = new Event();
        e.widget = this;
        SelectionEvent event = new SelectionEvent(e);
        event.data = this.getSelection();
        event.widget = this;
        event.display = Display.getCurrent();
        for (SelectionListener listener : this.selectionListeners) {
            listener.widgetSelected(event);
        }
    }

    public void redrawTextLayerImage() {
        if (this.wordsToUse == null) {
            return;
        }
        GC gc = new GC((Drawable)this.textLayerImage);
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, this.textLayerImage.getBounds().width, this.textLayerImage.getBounds().height);
        for (Word word : this.wordsToUse) {
            this.drawWord(gc, word, word.getColor());
        }
        gc.dispose();
        this.setSelection(this.getSelection());
    }

    public Set<Word> getSelection() {
        this.checkWidget();
        return new HashSet<Word>(this.selection);
    }

    public void setSelectionColor(Color color) {
        this.checkWidget();
        Assert.isLegal((color != null ? 1 : 0) != 0, (String)"Color must not be null!");
        this.highlightColor = color;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        Assert.isLegal((color != null ? 1 : 0) != 0, (String)"Color must not be null!");
        super.setBackground(color);
    }

    public int layoutCloud(IProgressMonitor monitor, boolean recalc) {
        this.checkWidget();
        this.resetLayout();
        if (this.selectionLayerImage != null) {
            this.selectionLayerImage.dispose();
            this.selectionLayerImage = null;
        }
        this.regionOffset = new Point(0, 0);
        if (this.textLayerImage != null) {
            this.textLayerImage.dispose();
        }
        int placedWords = 0;
        try {
            if (recalc) {
                this.calcExtents(monitor);
            }
            placedWords = this.layoutWords(this.wordsToUse, monitor);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TagCloud_ErrorWhileLayouting_Title, (String)(Messages.TagCloud_ErrorWhileLayouting_Message + e.getMessage()));
            e.printStackTrace();
        }
        this.redraw();
        this.updateScrollbars();
        return placedWords;
    }

    private void updateScrollbars() {
        if (this.zoomLayerImage == null) {
            return;
        }
        Rectangle rect = this.zoomLayerImage.getBounds();
        Rectangle client = this.getClientArea();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        if (hBar != null) {
            hBar.setMaximum(rect.width);
            hBar.setThumb(Math.min(rect.width, client.width));
            int hPage = rect.width - client.width;
            int hSelection = hBar.getSelection();
            if (hSelection >= hPage) {
                if (hPage <= 0) {
                    hSelection = 0;
                }
                this.origin.x = -hSelection;
            }
        }
        if (vBar != null) {
            vBar.setMaximum(rect.height);
            vBar.setThumb(Math.min(rect.height, client.height));
            int vPage = rect.height - client.height;
            int vSelection = vBar.getSelection();
            if (vSelection >= vPage) {
                if (vPage <= 0) {
                    vSelection = 0;
                }
                this.origin.y = -vSelection;
            }
        }
    }

    public void setMaxFontSize(int maxSize) {
        this.checkWidget();
        Assert.isLegal((maxSize > 0 ? 1 : 0) != 0, (String)("Font Size must be greater than zero, but was " + maxSize + "!"));
        this.maxFontSize = maxSize;
    }

    public void setOpacity(int opacity) {
        this.checkWidget();
        Assert.isLegal((opacity > 0 ? 1 : 0) != 0, (String)("Opacity must be greater than zero: " + opacity));
        Assert.isLegal((opacity < 256 ? 1 : 0) != 0, (String)("Opacity must be less than 256: " + opacity));
        this.opacity = opacity;
    }

    public void setMinFontSize(int size) {
        this.checkWidget();
        Assert.isLegal((size > 0 ? 1 : 0) != 0, (String)("Font Size must be greater zero: " + size));
        this.minFontSize = size;
    }

    public ImageData getImageData() {
        this.checkWidget();
        if (this.textLayerImage == null) {
            return null;
        }
        return this.textLayerImage.getImageData();
    }

    public void setBoost(int boost) {
        this.checkWidget();
        Assert.isLegal((boost >= 0 ? 1 : 0) != 0, (String)"Boost cannot be negative");
        this.boost = boost;
    }

    public void setAntiAlias(boolean enabled) {
        this.checkWidget();
        this.antialias = enabled ? 1 : 0;
    }

    public void setBoostFactor(float boostFactor) {
        Assert.isLegal((boostFactor != 0.0f ? 1 : 0) != 0);
        this.boostFactor = boostFactor;
    }

    public Color getSelectionColor() {
        return this.highlightColor;
    }

    public void setLayouter(ILayouter layouter) {
        this.checkWidget();
        Assert.isLegal((layouter != null ? 1 : 0) != 0, (String)"Layouter must not be null!");
        this.layouter = layouter;
    }

    public int getMaxFontSize() {
        this.checkWidget();
        return this.maxFontSize;
    }

    public int getMinFontSize() {
        this.checkWidget();
        return this.minFontSize;
    }

    public int getBoost() {
        this.checkWidget();
        return this.boost;
    }

    public float getBoostFactor() {
        this.checkWidget();
        return this.boostFactor;
    }

    public List<Word> getWords() {
        return this.wordsToUse;
    }

    public ILayouter getLayouter() {
        return this.layouter;
    }
}

