/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerMessages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;

public class CompilerUtils {
    public static Diagnostic createUnitProblemDiagnostic(CompiledUnit unit) {
        if (unit.getProblems().isEmpty()) {
            return Diagnostic.OK_INSTANCE;
        }
        URI uri = unit.getURI();
        List<QvtMessage> problems = unit.getProblems();
        ArrayList<QvtMessage> children = new ArrayList<QvtMessage>(problems.size());
        int errorCount = 0;
        int warnCount = 0;
        for (QvtMessage problem : unit.getProblems()) {
            if (problem.getSeverity() == 4) {
                ++errorCount;
            } else if (problem.getSeverity() == 2) {
                ++warnCount;
            }
            children.add(problem);
        }
        String mainMessage = NLS.bind(CompilerMessages.unitDiagnostic, errorCount, warnCount);
        BasicDiagnostic unitDiagnostic = new BasicDiagnostic(uri.toString(), 0, children, mainMessage, null);
        return unitDiagnostic;
    }

    public static void throwOperationCanceled() throws RuntimeException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            throw new RuntimeException("Operation canceled");
        }
        Eclipse.throwOperationCanceled();
    }

    static EPackage.Registry getEPackageRegistry(URI uri, IMetamodelRegistryProvider metamodelRegistryProvider) {
        MetamodelRegistry metamodelRegistry = metamodelRegistryProvider.getRegistry(CompilerUtils.createContext(uri));
        Object packageRegistry = metamodelRegistry != null ? metamodelRegistry.toEPackageRegistry() : new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        return packageRegistry;
    }

    public static ResourceSet cloneRegistrations(ResourceSet parentRs) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        EPackage.Registry packageRegistry = parentRs.getPackageRegistry();
        if (packageRegistry != null) {
            resSet.setPackageRegistry(packageRegistry);
        }
        if (parentRs instanceof ResourceSetImpl) {
            resSet.setURIResourceMap(((ResourceSetImpl)parentRs).getURIResourceMap());
            resSet.setResourceFactoryRegistry(parentRs.getResourceFactoryRegistry());
        }
        return resSet;
    }

    public static void addMappingsToResourceSet(ResourceSet resourceSet, URI context) {
        EPackage.Registry packageRegistry;
        IResource contextResource = URIUtils.getResource((URI)context);
        if (contextResource != null && (packageRegistry = MetamodelURIMappingHelper.mappingsToEPackageRegistry((IProject)contextResource.getProject(), (ResourceSet)resourceSet)) != null) {
            resourceSet.setPackageRegistry(packageRegistry);
        }
    }

    public static IMetamodelRegistryProvider.IRepositoryContext createContext(final URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        return new IMetamodelRegistryProvider.IRepositoryContext(){

            public URI getURI() {
                return uri;
            }
        };
    }

    static class Eclipse {
        Eclipse() {
        }

        static void throwOperationCanceled() throws RuntimeException {
            throw new OperationCanceledException();
        }
    }
}

