/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.gerrit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;

public abstract class FilteredSelectRepositoryPage
extends GitSelectRepositoryPage {
    public FilteredSelectRepositoryPage(String title, ImageDescriptor image) {
        super(false, false);
        this.setTitle(title);
        this.setDescription(null);
        this.setImageDescriptor(image);
    }

    @Override
    protected List<String> getInitialRepositories() {
        List configuredRepos = RepositoryUtil.INSTANCE.getConfiguredRepositories();
        return configuredRepos.stream().map(name -> {
            File gitDir = new File((String)name);
            if (gitDir.exists()) {
                try {
                    Repository repo = RepositoryCache.INSTANCE.lookupRepository(gitDir);
                    if (repo != null && this.includeRepository(repo)) {
                        return name;
                    }
                }
                catch (IOException e) {
                    Activator.logWarning(e.getLocalizedMessage(), e);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected abstract boolean includeRepository(@NonNull Repository var1);
}

