/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.builder;

import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ProjectConfigAdapter;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class PatternLanguageShouldGenerate
implements IShouldGenerate {
    public boolean shouldGenerate(Resource resource, CancelIndicator cancelIndicator) {
        URI uri = resource.getURI();
        if (uri == null || !uri.isPlatformResource()) {
            return false;
        }
        try {
            return this.calculateShouldGenerate(resource, uri);
        }
        catch (CoreException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    private boolean calculateShouldGenerate(Resource resource, URI uri) throws CoreException {
        ProjectConfigAdapter adapter;
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri.toPlatformString(true)));
        if (member != null && member.getType() == 1 && (adapter = ProjectConfigAdapter.findInEmfObject((Notifier)resource.getResourceSet())) != null) {
            IProjectConfig projectConfig = adapter.getProjectConfig();
            if (Objects.equals(member.getProject().getName(), projectConfig.getName())) {
                return this.isInSourceFolder(projectConfig, uri) && member.findMaxProblemSeverity(null, true, 2) != 2;
            }
        }
        return false;
    }

    private boolean isInSourceFolder(IProjectConfig config, URI uri) {
        if (config.findSourceFolderContaining(uri) == null) {
            return config.getSourceFolders().stream().anyMatch(folder -> {
                URI folderUri = folder.getPath();
                if (folderUri.segment(folderUri.segmentCount() - 1).isEmpty()) {
                    return UriUtil.isPrefixOf((URI)folderUri.trimSegments(1), (URI)uri);
                }
                return false;
            });
        }
        return true;
    }
}

