/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.componentization.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManagerListener;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class DiagramDescriptionMappingsManagerImpl
implements DiagramDescriptionMappingsManager {
    private final DiagramDescription description;
    private EList<NodeMapping> nodeMappings;
    private EList<ContainerMapping> containerMappings;
    private EList<EdgeMapping> edgeMappings;
    private final List<DiagramDescriptionMappingsManagerListener> listeners;

    public DiagramDescriptionMappingsManagerImpl(DiagramDescription description) {
        this.description = description;
        this.listeners = new ArrayList<DiagramDescriptionMappingsManagerListener>(2);
    }

    @Override
    public void computeMappings(Collection<Viewpoint> enabledViewpoints) {
        this.nodeMappings = new DiagramComponentizationManager().getAllNodeMappings(enabledViewpoints, this.description);
        this.edgeMappings = new DiagramComponentizationManager().getAllEdgeMappings(enabledViewpoints, this.description);
        this.containerMappings = new DiagramComponentizationManager().getAllContainerMappings(enabledViewpoints, this.description);
        for (DiagramDescriptionMappingsManagerListener listener : this.listeners) {
            listener.mappingsComputed(enabledViewpoints);
        }
    }

    @Override
    public List<NodeMapping> getNodeMappings() {
        return this.nodeMappings;
    }

    @Override
    public List<ContainerMapping> getContainerMappings() {
        return this.containerMappings;
    }

    @Override
    public List<EdgeMapping> getEdgeMappings() {
        return this.edgeMappings;
    }

    @Override
    public List<ContainerMapping> getContainerMappings(ContainerMapping containerMapping) {
        EList result = Collections.emptyList();
        if (containerMapping != null) {
            result = MappingHelper.getAllContainerMappings((ContainerMapping)containerMapping);
        }
        return result;
    }

    @Override
    public List<NodeMapping> getNodeMappings(ContainerMapping containerMapping) {
        EList result = Collections.emptyList();
        if (containerMapping != null) {
            result = MappingHelper.getAllNodeMappings((ContainerMapping)containerMapping);
        }
        return result;
    }

    @Override
    public List<NodeMapping> getBorderedNodeMappings(AbstractNodeMapping mapping) {
        EList result = Collections.emptyList();
        if (mapping != null) {
            result = MappingHelper.getAllBorderedNodeMappings((AbstractNodeMapping)mapping);
        }
        return result;
    }

    @Override
    public void addListener(DiagramDescriptionMappingsManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DiagramDescriptionMappingsManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isLayerMode() {
        return !LayerService.withoutLayersMode(this.description);
    }

    @Override
    public void dispose() {
        for (DiagramDescriptionMappingsManagerListener listener : this.listeners) {
            listener.dispose();
        }
        this.listeners.clear();
    }
}

