/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptUtils;
import org.eclipse.dltk.core.search.IDLTKSearchConstants;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.search.PatternStrings;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.internal.ui.search.SearchUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.PatternQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class ScriptSearchPage
extends DialogPage
implements ISearchPage,
IDLTKSearchConstants {
    public static final String PARTICIPANT_EXTENSION_POINT = "org.eclipse.dltk.ui.queryParticipants";
    @Deprecated
    public static final String EXTENSION_POINT_ID = "org.eclipse.dltk.ui.DLTKSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "DLTKSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List<SearchPatternData> fPreviousSearchPatterns;
    private SearchPatternData fInitialData;
    private IModelElement fModelElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private String[] fSearchForText = new String[]{SearchMessages.SearchPage_searchFor_type, SearchMessages.SearchPage_searchFor_method, SearchMessages.SearchPage_searchFor_field};
    private Button[] fLimitTo;
    private String[] fLimitToText = new String[]{SearchMessages.SearchPage_limitTo_declarations, SearchMessages.SearchPage_limitTo_references, SearchMessages.SearchPage_limitTo_allOccurrences};
    private Button fIncludeInterpreterEnvironmentCheckbox;

    public ScriptSearchPage() {
        this.fPreviousSearchPatterns = new ArrayList<SearchPatternData>();
    }

    public boolean performAction() {
        return this.performNewSearch();
    }

    private boolean performNewSearch() {
        SearchPatternData data = this.getPatternData();
        IDLTKSearchScope scope = null;
        String scopeDescription = "";
        boolean includeInterpreterEnvironment = data.includesInterpreterEnvironment();
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = factory.getWorkspaceScopeDescription(includeInterpreterEnvironment);
                scope = factory.createWorkspaceScope(includeInterpreterEnvironment, this.getLanguageToolkit());
                break;
            }
            case 1: {
                IModelElement[] modelElements = factory.getModelElements(this.getContainer().getSelection());
                scope = factory.createSearchScope(modelElements, includeInterpreterEnvironment, this.getLanguageToolkit());
                scopeDescription = factory.getSelectionScopeDescription(modelElements, includeInterpreterEnvironment);
                break;
            }
            case 3: {
                ArrayList<String> res = new ArrayList<String>();
                String[] projectNames = this.getContainer().getSelectedProjectNames();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int i = 0;
                while (i < projectNames.length) {
                    this.getEnclosingProjects(res, projectNames[i], root);
                    ++i;
                }
                scope = factory.createProjectSearchScope(res.toArray(new String[res.size()]), includeInterpreterEnvironment, this.getLanguageToolkit());
                scopeDescription = factory.getProjectScopeDescription(projectNames, includeInterpreterEnvironment);
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = factory.getWorkingSetScopeDescription(workingSets, includeInterpreterEnvironment);
                scope = factory.createSearchScope(workingSets, includeInterpreterEnvironment, this.getLanguageToolkit());
                SearchUtil.updateLRUWorkingSets(workingSets);
            }
        }
        QuerySpecification querySpec = null;
        if (data.getModelElement() != null && this.getPattern().equals(this.fInitialData.getPattern())) {
            querySpec = new ElementQuerySpecification(data.getModelElement(), data.getLimitTo(), scope, scopeDescription);
        } else {
            querySpec = new PatternQuerySpecification(data.getPattern(), data.getSearchFor(), data.isCaseSensitive(), data.getLimitTo(), scope, scopeDescription);
            data.setModelElement(null);
        }
        DLTKSearchQuery textSearchJob = new DLTKSearchQuery(querySpec);
        NewSearchUI.runQueryInBackground((ISearchQuery)textSearchJob);
        return true;
    }

    private void getEnclosingProjects(ArrayList<String> res, String projectName, IWorkspaceRoot root) {
        if (res.contains(projectName)) {
            return;
        }
        IScriptProject project = DLTKCore.create((IProject)root.getProject(projectName));
        if (project.exists()) {
            res.add(project.getProject().getName());
            try {
                IBuildpathEntry[] resolvedBuildpath;
                IBuildpathEntry[] iBuildpathEntryArray = resolvedBuildpath = project.getResolvedBuildpath(true);
                int n = resolvedBuildpath.length;
                int n2 = 0;
                while (n2 < n) {
                    IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
                    if (buildpathEntry.getEntryKind() == 2) {
                        this.getEnclosingProjects(res, buildpathEntry.getPath().lastSegment(), root);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
    }

    private int getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            if (this.fLimitTo[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setLimitTo(int searchFor, int limitTo) {
        int i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setSelection(limitTo == i);
            ++i;
        }
        this.fLimitTo[0].setEnabled(true);
        this.fLimitTo[1].setEnabled(true);
        this.fLimitTo[2].setEnabled(true);
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = this.fPreviousSearchPatterns.get(i).getPattern();
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.getPattern())) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = this.findInPrevious(pattern);
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), pattern, this.fCaseSensitive.getSelection(), this.fModelElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets(), this.fIncludeInterpreterEnvironmentCheckbox.getSelection());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control limitTo = this.createLimitTo(result);
        limitTo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fIncludeInterpreterEnvironmentCheckbox = new Button(result, 32);
        this.fIncludeInterpreterEnvironmentCheckbox.setText(SearchMessages.SearchPage_searchInterpreterEnvironment_label);
        this.fIncludeInterpreterEnvironmentCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        SelectionAdapter modelElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget instanceof Button && !((Button)event.widget).getSelection()) {
                    return;
                }
                ScriptSearchPage.this.fModelElement = ScriptSearchPage.this.getSearchFor() == ScriptSearchPage.this.fInitialData.getSearchFor() ? ScriptSearchPage.this.fInitialData.getModelElement() : null;
                ScriptSearchPage.this.setLimitTo(ScriptSearchPage.this.getSearchFor(), ScriptSearchPage.this.getLimitTo());
                ScriptSearchPage.this.doPatternModified();
            }
        };
        this.fSearchFor[0].addSelectionListener((SelectionListener)modelElementInitializer);
        this.fSearchFor[1].addSelectionListener((SelectionListener)modelElementInitializer);
        this.fSearchFor[2].addSelectionListener((SelectionListener)modelElementInitializer);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        if (DLTKCore.DEBUG) {
            System.out.println("TODO: Add help support here...");
        }
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText(SearchMessages.SearchPage_expression_label);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptSearchPage.this.handlePatternSelected();
                ScriptSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(e -> {
            this.doPatternModified();
            this.updateOKStatus();
        });
        TextFieldNavigationHandler.install(this.fPattern);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(SearchMessages.SearchPage_expression_caseSensitive);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptSearchPage.this.fIsCaseSensitive = ScriptSearchPage.this.fCaseSensitive.getSelection();
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    final void updateOKStatus() {
        boolean isValid = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(isValid);
    }

    private boolean isValidSearchPattern() {
        if (this.getPattern().length() == 0) {
            return false;
        }
        if (this.fModelElement != null) {
            return true;
        }
        return SearchPattern.createPattern((String)this.getPattern(), (int)this.getSearchFor(), (int)this.getLimitTo(), (int)0, (IDLTKLanguageToolkit)this.getLanguageToolkit()) != null;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fInitialData.getModelElement() != null && this.fInitialData.getSearchFor() == this.getSearchFor()) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
            this.fModelElement = this.fInitialData.getModelElement();
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
            this.fModelElement = null;
        }
    }

    private void handlePatternSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData initialData = this.fPreviousSearchPatterns.get(selectionIndex);
        this.setSearchFor(initialData.getSearchFor());
        this.setLimitTo(initialData.getSearchFor(), initialData.getLimitTo());
        this.fPattern.setText(initialData.getPattern());
        this.fIsCaseSensitive = initialData.isCaseSensitive();
        this.fModelElement = initialData.getModelElement();
        this.fCaseSensitive.setEnabled(this.fModelElement == null);
        this.fCaseSensitive.setSelection(initialData.isCaseSensitive());
        if (initialData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(initialData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(initialData.getScope());
        }
        this.fInitialData = initialData;
    }

    private void setSearchFor(int searchFor) {
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(searchFor == i);
            ++i;
        }
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_searchFor_label);
        result.setLayout((Layout)new GridLayout(2, true));
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fSearchForText[i]);
            button.setSelection(i == 0);
            button.setLayoutData((Object)new GridData());
            this.fSearchFor[i] = button;
            ++i;
        }
        Label filler = new Label((Composite)result, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_limitTo_label);
        result.setLayout((Layout)new GridLayout(2, true));
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof Button && !((Button)e.widget).getSelection()) {
                    return;
                }
                ScriptSearchPage.this.updateUseInterpreterEnvironment();
            }
        };
        this.fLimitTo = new Button[this.fLimitToText.length];
        int i = 0;
        while (i < this.fLimitToText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fLimitToText[i]);
            this.fLimitTo[i] = button;
            button.setSelection(i == 1);
            button.addSelectionListener((SelectionListener)listener);
            button.setLayoutData((Object)new GridData());
            ++i;
        }
        return result;
    }

    private void initSelections() {
        ISelection sel = this.getContainer().getSelection();
        SearchPatternData initData = null;
        if (sel instanceof IStructuredSelection) {
            initData = this.tryStructuredSelection((IStructuredSelection)sel);
        } else if (sel instanceof ITextSelection) {
            IEditorPart activePart = this.getActiveEditor();
            if (activePart != null) {
                if (ScriptUtils.checkNature((String)this.getLanguageToolkit().getNatureId(), (Object)activePart, (boolean)true)) {
                    try {
                        IModelElement[] elements = SelectionConverter.codeResolve(activePart);
                        if (elements != null && elements.length > 0) {
                            initData = this.determineInitValuesFrom(elements[0]);
                        }
                    }
                    catch (ModelException modelException) {}
                } else {
                    initData = this.getDefaultInitValues();
                }
            }
            if (initData == null) {
                initData = this.trySimpleTextSelection((ITextSelection)sel);
            }
        }
        if (initData == null) {
            initData = this.getDefaultInitValues();
        }
        this.fInitialData = initData;
        this.fModelElement = initData.getModelElement();
        this.fCaseSensitive.setSelection(initData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fModelElement == null);
        this.setSearchFor(initData.getSearchFor());
        this.setLimitTo(initData.getSearchFor(), initData.getLimitTo());
        this.fPattern.setText(initData.getPattern());
        boolean forceIncludeInterpreterEnvironment = ScriptSearchPage.forceIncludeInterpreterEnvironment(this.getLimitTo());
        this.fIncludeInterpreterEnvironmentCheckbox.setEnabled(!forceIncludeInterpreterEnvironment);
        this.fIncludeInterpreterEnvironmentCheckbox.setSelection(forceIncludeInterpreterEnvironment || initData.includesInterpreterEnvironment());
    }

    private void updateUseInterpreterEnvironment() {
        boolean forceIncludeInterpreterEnvironment = ScriptSearchPage.forceIncludeInterpreterEnvironment(this.getLimitTo());
        this.fIncludeInterpreterEnvironmentCheckbox.setEnabled(!forceIncludeInterpreterEnvironment);
        boolean isSelected = true;
        isSelected = !forceIncludeInterpreterEnvironment ? this.fIncludeInterpreterEnvironmentCheckbox.getSelection() : true;
        this.fIncludeInterpreterEnvironmentCheckbox.setSelection(isSelected);
    }

    private static boolean forceIncludeInterpreterEnvironment(int limitTo) {
        return limitTo == 0;
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection selection) {
        IWorkbenchAdapter adapter;
        IModelElement element;
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        SearchPatternData res = null;
        if (o instanceof IModelElement) {
            res = this.determineInitValuesFrom((IModelElement)o);
        } else if (o instanceof IAdaptable && (element = (IModelElement)((IAdaptable)o).getAdapter(IModelElement.class)) != null) {
            res = this.determineInitValuesFrom(element);
        }
        if (res == null && o instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class)) != null) {
            return new SearchPatternData(0, 1, this.fIsCaseSensitive, adapter.getLabel(o), null, false);
        }
        return res;
    }

    static final boolean isSearchableType(IModelElement element) {
        switch (element.getElementType()) {
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private SearchPatternData determineInitValuesFrom(IModelElement element) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (toolkit != null && !toolkit.getNatureId().equals(this.getLanguageToolkit().getNatureId())) {
            return null;
        }
        DLTKSearchScopeFactory factory = DLTKSearchScopeFactory.getInstance();
        boolean isInsideInterpreterEnvironment = factory.isInsideInterpreter(element);
        switch (element.getElementType()) {
            case 4: {
                break;
            }
            case 7: {
                return new SearchPatternData(0, 1, true, PatternStrings.getTypeSignature((IType)element), element, isInsideInterpreterEnvironment);
            }
            case 5: {
                if (!DLTKCore.DEBUG) break;
                System.out.println("TODO: DLTKSearchPage: Add init values for source module support.");
                break;
            }
            case 8: {
                return new SearchPatternData(2, 1, true, PatternStrings.getFieldSignature((IField)element), element, isInsideInterpreterEnvironment);
            }
            case 9: {
                IMethod method = (IMethod)element;
                int searchFor = 1;
                return new SearchPatternData(searchFor, 1, true, PatternStrings.getMethodSignature(method), element, isInsideInterpreterEnvironment);
            }
        }
        return null;
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    private SearchPatternData trySimpleTextSelection(ITextSelection selection) {
        String selectedText = selection.getText();
        if (selectedText != null && selectedText.length() > 0) {
            int i = 0;
            while (i < selectedText.length() && !ScriptSearchPage.isLineDelimiterChar(selectedText.charAt(i))) {
                ++i;
            }
            if (i > 0) {
                return new SearchPatternData(0, 1, this.fIsCaseSensitive, selectedText.substring(0, i), null, true);
            }
        }
        return null;
    }

    private SearchPatternData getDefaultInitValues() {
        if (!this.fPreviousSearchPatterns.isEmpty()) {
            return this.fPreviousSearchPatterns.get(0);
        }
        return new SearchPatternData(0, 1, this.fIsCaseSensitive, "", null, false);
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = DLTKUIPlugin.getActivePage();
        if (activePage != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        String pageName = String.valueOf(this.getLanguageToolkit().getLanguageName()) + PAGE_NAME;
        IDialogSettings settings = DLTKUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(pageName);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(pageName);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    protected abstract IDLTKLanguageToolkit getLanguageToolkit();

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private IModelElement modelElement;
        private boolean includeInterpreterEnvironment;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int searchFor, int limitTo, boolean isCaseSensitive, String pattern, IModelElement element, boolean includeInterpreterEnvironment) {
            this(searchFor, limitTo, pattern, isCaseSensitive, element, 0, null, includeInterpreterEnvironment);
        }

        public SearchPatternData(int searchFor, int limitTo, String pattern, boolean isCaseSensitive, IModelElement element, int scope, IWorkingSet[] workingSets, boolean includeInterpreterEnvironment) {
            this.searchFor = searchFor;
            this.limitTo = limitTo;
            this.pattern = pattern;
            this.isCaseSensitive = isCaseSensitive;
            this.scope = scope;
            this.workingSets = workingSets;
            this.includeInterpreterEnvironment = includeInterpreterEnvironment;
            this.setModelElement(element);
        }

        public void setModelElement(IModelElement modelElement) {
            this.modelElement = modelElement;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public IModelElement getModelElement() {
            return this.modelElement;
        }

        public int getLimitTo() {
            return this.limitTo;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public boolean includesInterpreterEnvironment() {
            return this.includeInterpreterEnvironment;
        }

        public void store(IDialogSettings settings) {
            settings.put("searchFor", this.searchFor);
            settings.put("scope", this.scope);
            settings.put("pattern", this.pattern);
            settings.put("limitTo", this.limitTo);
            settings.put("modelElement", this.modelElement != null ? this.modelElement.getHandleIdentifier() : "");
            settings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getName();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
            settings.put("includeInterpreterEnvironment", this.includeInterpreterEnvironment);
        }

        public static SearchPatternData create(IDialogSettings settings) {
            IModelElement restored;
            String pattern = settings.get("pattern");
            if (pattern.length() == 0) {
                return null;
            }
            IModelElement elem = null;
            String handleId = settings.get("modelElement");
            if (handleId != null && handleId.length() > 0 && (restored = DLTKCore.create((String)handleId)) != null && ScriptSearchPage.isSearchableType(restored) && restored.exists()) {
                elem = restored;
            }
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int searchFor = settings.getInt("searchFor");
                int scope = settings.getInt("scope");
                int limitTo = settings.getInt("limitTo");
                boolean isCaseSensitive = settings.getBoolean("isCaseSensitive");
                boolean includeInterpreterEnvironment = settings.get("includeInterpreterEnvironment") != null ? settings.getBoolean("includeInterpreterEnvironment") : ScriptSearchPage.forceIncludeInterpreterEnvironment(limitTo);
                return new SearchPatternData(searchFor, limitTo, pattern, isCaseSensitive, elem, scope, workingSets, includeInterpreterEnvironment);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

