/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteResource;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Util {
    public static URI getLocationURI(IProject prj) {
        IRemoteResource resource = (IRemoteResource)prj.getAdapter(IRemoteResource.class);
        if (resource != null) {
            URI locationURI = resource.getActiveLocationURI();
            return locationURI;
        }
        return null;
    }

    public static IRemoteConnection getRemoteConnection(IProject prj) {
        IRemoteConnection conn;
        IRemoteServicesManager svcMgr;
        IRemoteConnectionType connType;
        URI locationURI;
        IRemoteResource resource = (IRemoteResource)prj.getAdapter(IRemoteResource.class);
        if (resource != null && (locationURI = resource.getActiveLocationURI()) != null && (connType = (svcMgr = Util.getService(IRemoteServicesManager.class)).getConnectionType(locationURI)) != null && (conn = connType.getConnection(locationURI)) != null) {
            return conn;
        }
        return null;
    }

    private static <T> T getService(Class<T> service) {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

