/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class ChainIterator<E>
implements Iterator<E> {
    private E next;
    private final Transformer<? super E, ? extends E> transformer;

    public ChainIterator(E first, Transformer<? super E, ? extends E> transformer) {
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.next = first;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.next = this.transformer.transform(this.next);
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.next);
    }
}

