/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core.qmljs;

import org.eclipse.cdt.qt.core.qmljs.IJSExpression;

public interface IJSUnaryExpression
extends IJSExpression {
    @Override
    default public String getType() {
        return "UnaryExpression";
    }

    public UnaryOperator getOperator();

    public boolean isPrefix();

    public IJSExpression getArgument();

    public static enum UnaryOperator {
        Negation("-"),
        Plus("+"),
        Not("!"),
        BitwiseNot("~"),
        Typeof("typeof"),
        Void("void"),
        Delete("delete");

        private final String op;

        public static UnaryOperator fromObject(Object obj) {
            if (obj instanceof String) {
                UnaryOperator[] unaryOperatorArray = UnaryOperator.values();
                int n = unaryOperatorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UnaryOperator op = unaryOperatorArray[n2];
                    if (obj.equals(op.toString())) {
                        return op;
                    }
                    ++n2;
                }
            }
            return null;
        }

        private UnaryOperator(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

