/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher.ui.launchbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.docker.launcher.SWTImagesFactory;
import org.eclipse.cdt.internal.docker.launcher.ui.launchbar.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewContainerTargetWizardPage
extends WizardPage
implements IDockerImageListener,
IDockerConnectionManagerListener {
    private final ILaunchTarget launchTarget;
    private Text nameText;
    private Combo imageCombo;
    private Combo connectionSelector;
    private IDockerConnection connection;
    private IDockerConnection[] connections;
    private IDockerImageListener wizardPage;
    private String imageName;
    private String connectionName;
    private String connectionUri = "";
    private ModifyListener connectionModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            int index = NewContainerTargetWizardPage.this.connectionSelector.getSelectionIndex();
            if (NewContainerTargetWizardPage.this.connection != null) {
                NewContainerTargetWizardPage.this.connection.removeImageListener(NewContainerTargetWizardPage.this.wizardPage);
            }
            NewContainerTargetWizardPage.this.connection = NewContainerTargetWizardPage.this.connections[index];
            NewContainerTargetWizardPage.this.connectionUri = NewContainerTargetWizardPage.this.connection.getUri();
            if (!NewContainerTargetWizardPage.this.connectionName.equals(NewContainerTargetWizardPage.this.connection.getName())) {
                NewContainerTargetWizardPage.this.setErrorMessage(null);
                NewContainerTargetWizardPage.this.imageName = null;
                NewContainerTargetWizardPage.this.initializeImageCombo();
                NewContainerTargetWizardPage.this.setPageComplete(false);
            }
            NewContainerTargetWizardPage.this.connectionName = NewContainerTargetWizardPage.this.connection.getName();
        }
    };

    public NewContainerTargetWizardPage(ILaunchTarget launchTarget) {
        super(NewContainerTargetWizardPage.class.getName());
        if (launchTarget == null) {
            this.setTitle(Messages.NewContainerTargetWizardPage_title);
            this.setDescription(Messages.NewContainerTargetWizardPage_description);
        } else {
            this.setTitle(Messages.EditContainerTargetWizardPage_title);
            this.setDescription(Messages.EditContainerTargetWizardPage_description);
        }
        this.launchTarget = launchTarget;
        this.wizardPage = this;
        if (launchTarget != null) {
            this.connectionUri = launchTarget.getAttribute("connection_uri", null);
            this.imageName = launchTarget.getAttribute("image_id", null);
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(comp, 0);
        label.setText(Messages.NewContainerTargetWizardPage_name);
        this.nameText = new Text(comp, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.launchTarget != null) {
            this.nameText.setText(this.launchTarget.getId());
            this.nameText.setEnabled(false);
        }
        label = new Label(comp, 0);
        label.setText(Messages.NewContainerTargetWizardPage_connection);
        this.connectionSelector = new Combo(comp, 2056);
        this.initializeConnectionSelector();
        this.connectionSelector.addModifyListener(this.connectionModifyListener);
        this.connectionSelector.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = false;
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 5;
        this.connectionSelector.setLayoutData((Object)gd);
        Label imageSelectorLabel = new Label(comp, 0);
        imageSelectorLabel.setText(Messages.NewContainerTargetWizardPage_image);
        this.imageCombo = new Combo(comp, 4);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 2;
        gd2.horizontalIndent = 5;
        this.imageCombo.setLayoutData((Object)gd2);
        this.initializeImageCombo();
        this.imageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewContainerTargetWizardPage.this.imageName = NewContainerTargetWizardPage.this.imageCombo.getText();
                NewContainerTargetWizardPage.this.setPageComplete(NewContainerTargetWizardPage.this.imageName != null && !NewContainerTargetWizardPage.this.imageName.isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)comp);
    }

    public String getTargetName() {
        return this.nameText.getText().trim();
    }

    public String getConnectionURI() {
        return this.connectionUri;
    }

    public String getImageId() {
        return this.imageName;
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.cdt.docker.launcher.repository-middle.gif");
    }

    private void initializeConnectionSelector() {
        int defaultIndex = -1;
        this.connections = DockerConnectionManager.getInstance().getConnections();
        if (this.connections.length == 0) {
            this.setErrorMessage(Messages.NewContainerTargetWizardPage_no_connections);
            return;
        }
        String[] connectionNames = new String[this.connections.length];
        int i = 0;
        while (i < this.connections.length) {
            connectionNames[i] = this.connections[i].getName();
            if (this.connections[i].getUri().equals(this.connectionUri)) {
                defaultIndex = i;
            }
            ++i;
        }
        if (defaultIndex < 0) {
            defaultIndex = 0;
        }
        this.connectionSelector.setItems(connectionNames);
        if (this.connections.length > 0) {
            this.connectionSelector.setText(connectionNames[defaultIndex]);
            this.connection = this.connections[defaultIndex];
            this.connectionName = this.connection.getName();
            this.connectionUri = this.connection.getUri();
        }
    }

    private void initializeImageCombo() {
        if (this.connection != null) {
            List images = this.connection.getImages();
            if (images == null || images.size() == 0) {
                this.setErrorMessage(Messages.NewContainerTargetWizardPage_no_images);
                return;
            }
            this.connection.removeImageListener(this.wizardPage);
            ArrayList<String> imageNames = new ArrayList<String>();
            for (IDockerImage image : images) {
                List tags = image.repoTags();
                if (tags == null) continue;
                for (String tag : tags) {
                    if (tag.equals("<none>:<none>")) continue;
                    imageNames.add(tag);
                }
            }
            this.imageCombo.setItems(imageNames.toArray(new String[0]));
            if (this.imageName != null) {
                this.imageCombo.setText(this.imageName);
            }
            this.connection.addImageListener(this.wizardPage);
        }
    }

    public void changeEvent(IDockerConnection changedConnection, int type) {
        String currUri = null;
        int currIndex = 0;
        this.setErrorMessage(null);
        this.connections = DockerConnectionManager.getInstance().getConnections();
        if (this.connection != null) {
            currUri = this.connection.getUri();
            currIndex = this.connectionSelector.getSelectionIndex();
        }
        String[] connectionNames = new String[this.connections.length];
        int index = 0;
        int i = 0;
        while (i < this.connections.length) {
            connectionNames[i] = this.connections[i].getName();
            if (this.connections[i].getUri().equals(currUri)) {
                index = i;
            }
            ++i;
        }
        if (type == 2) {
            index = currIndex;
        }
        this.connectionSelector.removeModifyListener(this.connectionModifyListener);
        this.connectionSelector.setItems(connectionNames);
        if (connectionNames.length > 0) {
            this.connectionSelector.setText(connectionNames[index]);
            this.connection = this.connections[index];
            this.connectionUri = this.connection.getUri();
            List images = this.connection.getImages();
            if (images == null || images.size() == 0) {
                this.setErrorMessage(Messages.NewContainerTargetWizardPage_no_images);
            }
        } else {
            this.setErrorMessage(Messages.NewContainerTargetWizardPage_no_connections);
            this.connection = null;
            this.connectionUri = "";
            this.connectionSelector.setText("");
        }
        this.connectionSelector.addModifyListener(this.connectionModifyListener);
    }

    public void listChanged(IDockerConnection c, List<IDockerImage> list) {
        this.setErrorMessage(null);
        IDockerImage[] finalList = list.toArray(new IDockerImage[0]);
        if (finalList.length == 0) {
            this.setErrorMessage(Messages.NewContainerTargetWizardPage_no_images);
        }
        if (c.getName().equals(this.connection.getName())) {
            Display.getDefault().syncExec(() -> {
                this.connection.removeImageListener(this.wizardPage);
                ArrayList<String> imageNames = new ArrayList<String>();
                IDockerImage[] iDockerImageArray2 = finalList;
                int n = finalList.length;
                int n2 = 0;
                while (n2 < n) {
                    IDockerImage image = iDockerImageArray2[n2];
                    List tags = image.repoTags();
                    if (tags != null) {
                        for (String tag : tags) {
                            imageNames.add(tag);
                        }
                    }
                    ++n2;
                }
                if (!this.imageCombo.isDisposed()) {
                    this.imageCombo.setItems(imageNames.toArray(new String[0]));
                }
                this.connection.addImageListener(this.wizardPage);
            });
        }
    }

    public void dispose() {
        if (this.connection != null) {
            this.connection.removeImageListener((IDockerImageListener)this);
        }
        super.dispose();
    }
}

