/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.validation;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.jst.jsf.facelet.ui.internal.validation.ValidationReporter;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.facelet.FaceletDiagnosticFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public abstract class AbstractFaceletValidationStrategy {
    public static final int DONT_CARE = 0;
    protected final FaceletDiagnosticFactory _diagnosticFactory = new FaceletDiagnosticFactory();

    public int getPriority() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void validateFile(IFile file, IReporter reporter, IValidator caller) {
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                ValidationReporter jsfReporter = new ValidationReporter(caller, reporter, file, prefs, model);
                this.doValidate(file, jsfReporter);
                return;
            }
            catch (CoreException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected abstract void doValidate(IFile var1, IJSFViewValidator.IValidationReporter var2);

    public boolean shouldValidate(IFile model) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType contentType = manager.getContentType("org.eclipse.wst.html.core.htmlsource");
        return contentType.isAssociatedWith(model.getName()) && ViewUtil.isFaceletVDLFile((IFile)model);
    }
}

