/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class VariableRule
implements ISequenceRule {
    private String[] previousWords;
    private final IToken token;

    public VariableRule(String[] previousWords, IToken token) {
        this.previousWords = previousWords;
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    @Override
    public int read(ICharacterScanner scanner) {
        int column = scanner.getColumn();
        if (!this.validatePreviousWords(scanner)) {
            return 0;
        }
        assert (scanner.getColumn() == column);
        boolean result = true;
        boolean readNext = true;
        int shift = 0;
        while (result && readNext) {
            int n = this.readOneWord(scanner);
            if (n == 0) {
                result = false;
            } else {
                shift += n + this.readWhitespace(scanner);
                int c = scanner.read();
                if (c != 58) {
                    scanner.unread();
                    result = false;
                } else {
                    shift += 1 + this.readWhitespace(scanner);
                    n = this.readOneWord(scanner);
                    if (n == 0) {
                        result = false;
                    } else {
                        shift += n;
                    }
                }
            }
            if (!result) continue;
            int whitespaces = this.readWhitespace(scanner);
            int c = scanner.read();
            if (c != 44) {
                scanner.unread();
                while (whitespaces > 0) {
                    scanner.unread();
                    --whitespaces;
                }
                readNext = false;
                continue;
            }
            shift += whitespaces + 1;
            shift += this.readWhitespace(scanner);
        }
        if (!result) {
            while (shift > 0) {
                scanner.unread();
                --shift;
            }
        }
        return shift;
    }

    private boolean validatePreviousWords(ICharacterScanner scanner) {
        boolean valid = true;
        int shift = 0;
        int i = this.previousWords.length - 1;
        while (valid && i >= 0) {
            int n = this.unreadPreviousWord(scanner, this.previousWords[i]);
            if (n == 0) {
                valid = false;
            } else {
                shift += n;
            }
            --i;
        }
        while (shift < 0) {
            scanner.read();
            ++shift;
        }
        return valid;
    }

    private int unreadPreviousWord(ICharacterScanner scanner, String previousWord) {
        assert (previousWord.length() > 0);
        boolean valid = false;
        int shift = 0;
        if (scanner.getColumn() >= previousWord.length()) {
            int c;
            do {
                c = this.unreadChar(scanner);
                --shift;
            } while (Character.isWhitespace(c));
            if ("*".equals(previousWord)) {
                while (Character.isJavaIdentifierPart(c) && scanner.getColumn() > 0) {
                    valid = true;
                    c = this.unreadChar(scanner);
                    --shift;
                }
            } else if (scanner.getColumn() >= previousWord.length() - 1) {
                valid = true;
                int i = previousWord.length() - 1;
                while (valid && i >= 0) {
                    if (previousWord.charAt(i) != c) {
                        valid = false;
                    } else if (i > 0) {
                        c = this.unreadChar(scanner);
                        --shift;
                    }
                    --i;
                }
            }
        }
        if (!valid) {
            while (shift < 0) {
                scanner.read();
                ++shift;
            }
        }
        return shift;
    }

    private int unreadChar(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        scanner.unread();
        return c;
    }

    private int readOneWord(ICharacterScanner scanner) {
        int i = 0;
        int c = scanner.read();
        while (c != -1 && Character.isJavaIdentifierPart(c)) {
            c = scanner.read();
            ++i;
        }
        scanner.unread();
        return i;
    }

    private int readWhitespace(ICharacterScanner scanner) {
        int c = scanner.read();
        int n = 0;
        while (c != -1 && Character.isWhitespace(c)) {
            ++n;
            c = scanner.read();
        }
        scanner.unread();
        return n;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }
}

