/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.extensions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;

public class ViewersComponentConfiguration {
    private EMFScope scope;
    private Collection<IQuerySpecification<?>> patterns;
    private ViewerDataFilter filter;

    private ViewersComponentConfiguration() {
        this.scope = null;
        this.patterns = Sets.newHashSet();
        this.filter = ViewerDataFilter.UNFILTERED;
    }

    public ViewersComponentConfiguration(EMFScope _scope, Collection<IQuerySpecification<?>> _patterns, ViewerDataFilter _filter) {
        Assert.isNotNull((Object)_scope);
        Assert.isNotNull(_patterns);
        Assert.isNotNull((Object)_filter);
        this.setModel(_scope);
        this.setPatterns(_patterns);
        this.setFilter(_filter);
    }

    public ViewersComponentConfiguration(EMFScope _model, Collection<IQuerySpecification<?>> _patterns) {
        this(_model, _patterns, ViewerDataFilter.UNFILTERED);
    }

    public static ViewersComponentConfiguration fromQuerySpecs(Collection<? extends IQuerySpecification<?>> specs) {
        ViewersComponentConfiguration c = new ViewersComponentConfiguration();
        for (IQuerySpecification<?> spec : specs) {
            c.patterns.add(spec);
        }
        return c;
    }

    public static ViewersComponentConfiguration fromQuerySpecFQNs(Collection<String> fqns) {
        ViewersComponentConfiguration c = new ViewersComponentConfiguration();
        for (String fqn : fqns) {
            IQuerySpecificationRegistry registry = QuerySpecificationRegistry.getInstance();
            IQuerySpecification querySpecification = (IQuerySpecification)registry.getDefaultView().getEntry(fqn).get();
            c.patterns.add(querySpecification);
        }
        return c;
    }

    public EMFScope getScope() {
        return this.scope;
    }

    public void setModel(EMFScope model) {
        this.scope = model;
    }

    public Collection<IQuerySpecification<?>> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Collection<IQuerySpecification<?>> patterns) {
        this.patterns = patterns;
    }

    public ViewerDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ViewerDataFilter filter) {
        this.filter = filter;
    }

    public ViewersComponentConfiguration newCopy() {
        ArrayList r = Lists.newArrayList();
        r.addAll(this.getPatterns());
        return new ViewersComponentConfiguration(this.getScope(), r, this.getFilter());
    }
}

