/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.EncodingParser;

public final class StringDeclarationParser
implements ICommonTreeParser {
    public static final StringDeclarationParser INSTANCE = new StringDeclarationParser();
    private static final @NonNull String ENCODING = "encoding";

    private StringDeclarationParser() {
    }

    @Override
    public StringDeclaration parse(CommonTree string, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        List children = string.getChildren();
        StringDeclaration stringDeclaration = null;
        if (children == null) {
            stringDeclaration = StringDeclaration.getStringDeclaration(Encoding.UTF8);
        } else {
            Encoding encoding = Encoding.UTF8;
            for (CommonTree child : children) {
                switch (child.getType()) {
                    case 86: {
                        CommonTree leftNode = (CommonTree)child.getChild(0);
                        CommonTree rightNode = (CommonTree)child.getChild(1);
                        List leftStrings = leftNode.getChildren();
                        if (!TsdlUtils.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
                            throw new ParseException("Left side of ctf expression must be a string");
                        }
                        String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
                        if (left.equals(ENCODING)) {
                            encoding = EncodingParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        throw new ParseException("String: unknown attribute " + left);
                    }
                    default: {
                        throw TsdlUtils.childTypeError(child);
                    }
                }
            }
            stringDeclaration = StringDeclaration.getStringDeclaration(encoding);
        }
        return stringDeclaration;
    }
}

