/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TabItemHandler
extends ItemHandler {
    private static TabItemHandler instance;

    public static TabItemHandler getInstance() {
        if (instance == null) {
            instance = new TabItemHandler();
        }
        return instance;
    }

    public TabFolder getTabFolder(final TabItem swtTabItem) {
        return (TabFolder)Display.syncExec((ResultRunnable)new ResultRunnable<TabFolder>(){

            public TabFolder run() {
                return swtTabItem.getParent();
            }
        });
    }

    public Control getControl(final TabItem tabItem) {
        return (Control)Display.syncExec((ResultRunnable)new ResultRunnable<Control>(){

            public Control run() {
                return tabItem.getControl();
            }
        });
    }

    public Event createEventForTabItem(TabItem swtTabItem, int type) {
        Event event = new Event();
        event.type = type;
        event.display = Display.getDisplay();
        event.time = (int)System.currentTimeMillis();
        event.item = swtTabItem;
        event.widget = this.getTabFolder(swtTabItem);
        return event;
    }

    public void select(final TabItem swtTabItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTabItem.getParent().setSelection(swtTabItem);
            }
        });
        this.notifyTabFolder(this.createEventForTabItem(swtTabItem, 13), this.getParent(swtTabItem));
    }

    public boolean isSelected(final TabItem swtTabItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                TabItem[] selectedItems;
                TabItem[] tabItemArray = selectedItems = swtTabItem.getParent().getSelection();
                int n = selectedItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem i = tabItemArray[n2];
                    if (i.equals(swtTabItem)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public void setFocus(TabItem tabItem) {
        ControlHandler.getInstance().setFocus((Control)this.getParent(tabItem));
    }

    public TabFolder getParent(final TabItem tabItem) {
        return (TabFolder)Display.syncExec((ResultRunnable)new ResultRunnable<TabFolder>(){

            public TabFolder run() {
                return tabItem.getParent();
            }
        });
    }

    public String getToolTipText(final TabItem swtWidget) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return swtWidget.getToolTipText();
            }
        });
    }

    private void notifyTabFolder(final Event event, final TabFolder swtTabFolder) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTabFolder.notifyListeners(event.type, event);
            }
        });
    }
}

