/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HprofDumpProvider
extends IBMDumpProvider {
    HprofDumpProvider() {
    }

    @Override
    String dumpName() {
        return "java_pid%pid%.seq.hprof";
    }

    @Override
    int files() {
        return 1;
    }

    @Override
    long averageFileSize(Collection<File> files) {
        long l = 0L;
        int i = 0;
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".hprof")) continue;
            l += f.length();
            ++i;
        }
        if (i > 0) {
            return l / (long)i;
        }
        return 100000000L;
    }

    @Override
    public File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File javahome, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        if (compress) {
            if (dumps.size() != 1) {
                throw new IllegalArgumentException();
            }
            File dump = dumps.get(0);
            return this.compressFile(preferredDump, dump, listener);
        }
        return super.jextract(preferredDump, compress, dumps, udir, javahome, listener);
    }

    File compressFile(File preferredDump, File dump, IProgressListener listener) throws IOException {
        File dumpout = preferredDump.getCanonicalFile().equals(dump.getCanonicalFile()) ? File.createTempFile(dump.getName(), null, dump.getParentFile()) : preferredDump;
        int bufsize = 65536;
        int work = (int)(dumpout.length() / (long)bufsize);
        listener.beginTask(Messages.getString("IBMDumpProvider.CompressingDump"), work);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(dump), bufsize);
        try {
            GZIPOutputStream os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(dumpout)));
            try {
                byte[] buffer = new byte[bufsize];
                while (true) {
                    if (listener.isCanceled()) {
                        return null;
                    }
                    int r = ((InputStream)is).read(buffer);
                    if (r > 0) {
                        ((OutputStream)os).write(buffer, 0, r);
                        listener.worked(1);
                        continue;
                    }
                    break;
                }
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
        if (dump.delete()) {
            if (!dumpout.getCanonicalFile().equals(preferredDump.getCanonicalFile()) && !dumpout.renameTo(preferredDump)) {
                throw new IOException(preferredDump.getPath());
            }
        } else {
            if (!dumpout.delete()) {
                throw new IOException(dumpout.getPath());
            }
            preferredDump = dump;
        }
        listener.done();
        return preferredDump;
    }
}

